/*
 * Decompiled with CFR 0.152.
 */
package com.whalin.MemCached;

import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.command.DeletionCommand;
import com.whalin.MemCached.LineInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SockIOPool {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private static final Integer ZERO = 0;
    private int poolMultiplier = 3;
    private int minConn = 5;
    private int maxConn = 100;
    private int maxIdle = 300000;
    private long maxBusyTime = 30000L;
    private int socketTO = 3000;
    private int socketConnectTO = 3000;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = false;
    private final ReentrantLock hostDeadLock = new ReentrantLock();
    private Map<String, Date> hostDead;
    private Map<String, Long> hostDeadDur;
    private Map<String, Map<SockIO, Long>> availPool;
    private Map<String, Map<SockIO, Long>> busyPool;
    private Map<SockIO, Integer> deadPool;
    private SchoonerSockIOPool schoonerSockIOPool;
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 600000L;

    protected SockIOPool() {
    }

    public static synchronized SockIOPool getInstance(String poolName) {
        SockIOPool whalinSockIOPool = new SockIOPool();
        whalinSockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(poolName);
        return whalinSockIOPool;
    }

    public static SockIOPool getInstance(boolean isTcp) {
        SockIOPool whalinSockIOPool = new SockIOPool();
        whalinSockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(isTcp);
        return whalinSockIOPool;
    }

    public static SockIOPool getInstance(String poolName, boolean isTcp) {
        SockIOPool whalinSockIOPool = new SockIOPool();
        whalinSockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(poolName, isTcp);
        return whalinSockIOPool;
    }

    public static SockIOPool getInstance() {
        SockIOPool whalinSockIOPool = new SockIOPool();
        whalinSockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance("default");
        return whalinSockIOPool;
    }

    public void setServers(String[] servers) {
        this.schoonerSockIOPool.setServers(servers);
    }

    public String[] getServers() {
        return this.schoonerSockIOPool.getServers();
    }

    public void setWeights(Integer[] weights) {
        this.schoonerSockIOPool.setWeights(weights);
    }

    public Integer[] getWeights() {
        return this.schoonerSockIOPool.getWeights();
    }

    public void setInitConn(int initConn) {
        this.schoonerSockIOPool.setInitConn(initConn);
    }

    public int getInitConn() {
        return this.schoonerSockIOPool.getInitConn();
    }

    public void setMinConn(int minConn) {
        this.schoonerSockIOPool.setMinConn(minConn);
    }

    public int getMinConn() {
        return this.schoonerSockIOPool.getMinConn();
    }

    public void setMaxConn(int maxConn) {
        this.schoonerSockIOPool.setMaxConn(maxConn);
    }

    public int getMaxConn() {
        return this.schoonerSockIOPool.getMaxConn();
    }

    public void setMaxBusyTime(long maxBusyTime) {
        this.schoonerSockIOPool.setMaxBusyTime(maxBusyTime);
    }

    public long getMaxBusy() {
        return this.schoonerSockIOPool.getMaxBusy();
    }

    public void setSocketTO(int socketTO) {
        this.schoonerSockIOPool.setSocketTO(socketTO);
    }

    public int getSocketTO() {
        return this.schoonerSockIOPool.getSocketTO();
    }

    public void setSocketConnectTO(int socketConnectTO) {
        this.schoonerSockIOPool.setSocketConnectTO(socketConnectTO);
    }

    public int getSocketConnectTO() {
        return this.schoonerSockIOPool.getSocketTO();
    }

    public void setMaxIdle(int maxIdle) {
        this.schoonerSockIOPool.setMaxIdle(maxIdle);
    }

    public int getMaxIdle() {
        return this.schoonerSockIOPool.getMaxIdle();
    }

    public void setMaintSleep(long maintSleep) {
        this.schoonerSockIOPool.setMaintSleep(maintSleep);
    }

    public long getMaintSleep() {
        return this.schoonerSockIOPool.getMaintSleep();
    }

    public void setFailover(boolean failover) {
        this.schoonerSockIOPool.setFailover(failover);
    }

    public boolean getFailover() {
        return this.schoonerSockIOPool.getFailover();
    }

    public void setFailback(boolean failback) {
        this.schoonerSockIOPool.setFailback(failback);
    }

    public boolean getFailback() {
        return this.schoonerSockIOPool.getFailback();
    }

    public void setAliveCheck(boolean aliveCheck) {
        this.schoonerSockIOPool.setAliveCheck(aliveCheck);
    }

    public boolean getAliveCheck() {
        return this.schoonerSockIOPool.getAliveCheck();
    }

    public void setNagle(boolean nagle) {
        this.schoonerSockIOPool.setNagle(nagle);
    }

    public boolean getNagle() {
        return this.schoonerSockIOPool.getNagle();
    }

    public void setHashingAlg(int alg) {
        this.schoonerSockIOPool.setHashingAlg(alg);
    }

    public int getHashingAlg() {
        return this.schoonerSockIOPool.getHashingAlg();
    }

    public void initialize() {
        this.schoonerSockIOPool.initialize();
    }

    public boolean isInitialized() {
        return this.schoonerSockIOPool.isInitialized();
    }

    public String getHost(String key) {
        return this.schoonerSockIOPool.getHost(key);
    }

    public String getHost(String key, Integer hashcode) {
        return this.schoonerSockIOPool.getHost(key, hashcode);
    }

    public void shutDown() {
        this.schoonerSockIOPool.shutDown();
    }

    public void setBufferSize(int bufferSize) {
        this.schoonerSockIOPool.setBufferSize(bufferSize);
    }

    public int getBufferSize() {
        return this.schoonerSockIOPool.getBufferSize();
    }

    public SockIO getSock(String key) {
        return this.schoonerSockIOPool.getSock(key);
    }

    public SockIO getSock(String key, Integer hashCode) {
        return this.schoonerSockIOPool.getSock(key, hashCode);
    }

    public SockIO getConnection(String host) {
        return this.schoonerSockIOPool.getConnection(host);
    }

    private void checkIn(SockIO socket) {
        this.checkIn(socket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIn(SockIO socket, boolean addToAvail) {
        String host = socket.getHost();
        LOG.debug("++++ calling check-in on socket: " + socket.toString() + " for host: " + host);
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            LOG.debug("++++ removing socket (" + socket.toString() + ") from busy pool for host: " + host);
            this.removeSocketFromPool(this.busyPool, host, socket);
            if (socket.isConnected() && addToAvail) {
                LOG.debug("++++ returning socket (" + socket.toString() + " to avail pool for host: " + host);
                this.addSocketToPool(this.availPool, host, socket);
            } else {
                this.deadPool.put(socket, ZERO);
                socket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SockIO createSocket(String host) {
        long expire;
        SockIO socket = null;
        this.hostDeadLock.lock();
        try {
            if (this.failover && this.failback && this.hostDead.containsKey(host) && this.hostDeadDur.containsKey(host)) {
                Date store = this.hostDead.get(host);
                expire = this.hostDeadDur.get(host);
                if (store.getTime() + expire > System.currentTimeMillis()) {
                    SockIO sockIO = null;
                    return sockIO;
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        try {
            socket = new SockIO(this, host, this.socketTO, this.socketConnectTO, this.nagle);
            if (!socket.isConnected()) {
                LOG.error("++++ failed to get SockIO obj for: " + host + " -- new socket is not connected");
                this.deadPool.put(socket, ZERO);
                socket = null;
            }
        }
        catch (Exception ex) {
            LOG.error("++++ failed to get SockIO obj for: " + host);
            LOG.error(ex.getMessage(), (Throwable)ex);
            socket = null;
        }
        this.hostDeadLock.lock();
        try {
            if (socket == null) {
                Date now = new Date();
                this.hostDead.put(host, now);
                long l = expire = this.hostDeadDur.containsKey(host) ? this.hostDeadDur.get(host) * 2L : 1000L;
                if (expire > 600000L) {
                    expire = 600000L;
                }
                this.hostDeadDur.put(host, expire);
                LOG.debug("++++ ignoring dead host: " + host + " for " + expire + " ms");
                this.clearHostFromPool(this.availPool, host);
            } else {
                LOG.debug("++++ created socket (" + socket.toString() + ") for host: " + host);
                if (this.hostDead.containsKey(host) || this.hostDeadDur.containsKey(host)) {
                    this.hostDead.remove(host);
                    this.hostDeadDur.remove(host);
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfMaint() {
        Set<SockIO> toClose;
        LOG.debug("++++ Starting self maintenance....");
        HashMap<String, Integer> needSockets = new HashMap<String, Integer>();
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            for (String map : this.availPool.keySet()) {
                Map<SockIO, Long> sockets = this.availPool.get(map);
                LOG.debug("++++ Size of avail pool for host (" + map + ") = " + sockets.size());
                if (sockets.size() >= this.minConn) continue;
                int need = this.minConn - sockets.size();
                needSockets.put(map, need);
            }
        }
        HashMap newSockets = new HashMap();
        for (String string : needSockets.keySet()) {
            SockIO socket;
            Integer need = (Integer)needSockets.get(string);
            LOG.debug("++++ Need to create " + need + " new sockets for pool for host: " + string);
            HashSet<SockIO> newSock = new HashSet<SockIO>(need);
            for (int j = 0; j < need && (socket = this.createSocket(string)) != null; ++j) {
                newSock.add(socket);
            }
            newSockets.put(string, newSock);
        }
        SockIOPool i = this;
        synchronized (i) {
            for (String host : newSockets.keySet()) {
                Set sockets = (Set)newSockets.get(host);
                for (SockIO socket : sockets) {
                    this.addSocketToPool(this.availPool, host, socket);
                }
            }
            for (String host : this.availPool.keySet()) {
                Map<SockIO, Long> sockets = this.availPool.get(host);
                LOG.debug("++++ Size of avail pool for host (" + host + ") = " + sockets.size());
                if (sockets.size() <= this.maxConn) continue;
                int diff = sockets.size() - this.maxConn;
                int needToClose = diff <= this.poolMultiplier ? diff : diff / this.poolMultiplier;
                LOG.debug("++++ need to remove " + needToClose + " spare sockets for pool for host: " + host);
                Iterator<SockIO> j = sockets.keySet().iterator();
                while (j.hasNext() && needToClose > 0) {
                    SockIO socket = j.next();
                    long expire = sockets.get(socket);
                    if (expire + (long)this.maxIdle >= System.currentTimeMillis()) continue;
                    LOG.debug("+++ removing stale entry from pool as it is past its idle timeout and pool is over max spare");
                    this.deadPool.put(socket, ZERO);
                    j.remove();
                    --needToClose;
                }
            }
            for (String host : this.busyPool.keySet()) {
                Map<SockIO, Long> sockets = this.busyPool.get(host);
                LOG.debug("++++ Size of busy pool for host (" + host + ")  = " + sockets.size());
                Iterator<SockIO> j = sockets.keySet().iterator();
                while (j.hasNext()) {
                    SockIO socket = j.next();
                    long hungTime = sockets.get(socket);
                    if (hungTime + this.maxBusyTime >= System.currentTimeMillis()) continue;
                    LOG.error("+++ removing potentially hung connection from busy pool ... socket in pool for " + (System.currentTimeMillis() - hungTime) + "ms");
                    this.deadPool.put(socket, ZERO);
                    j.remove();
                }
            }
        }
        Map<SockIO, Integer> map = this.deadPool;
        synchronized (map) {
            toClose = this.deadPool.keySet();
            this.deadPool = new IdentityHashMap<SockIO, Integer>();
        }
        for (SockIO socket : toClose) {
            try {
                socket.trueClose(false);
            }
            catch (Exception ex) {
                LOG.error("++++ failed to close SockIO obj from deadPool");
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            socket = null;
        }
        LOG.debug("+++ ending self maintenance.");
    }

    protected void addSocketToPool(Map<String, Map<SockIO, Long>> pool, String host, SockIO socket) {
        Map<Object, Object> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null) {
            sockets.put(socket, System.currentTimeMillis());
            return;
        }
        sockets = new IdentityHashMap();
        sockets.put(socket, System.currentTimeMillis());
        pool.put(host, sockets);
    }

    protected void removeSocketFromPool(Map<String, Map<SockIO, Long>> pool, String host, SockIO socket) {
        Map<SockIO, Long> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null) {
            sockets.remove(socket);
        }
    }

    protected void clearHostFromPool(Map<String, Map<SockIO, Long>> pool, String host) {
        Map<SockIO, Long> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null && sockets.size() > 0) {
            Iterator<SockIO> i = sockets.keySet().iterator();
            while (i.hasNext()) {
                SockIO socket = i.next();
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    LOG.error("++++ failed to close socket: " + ioe.getMessage());
                }
                i.remove();
                socket = null;
            }
        }
    }

    public static class SockIO
    implements LineInputStream,
    AutoCloseable {
        private SockIOPool pool;
        private String host;
        private Socket sock;
        private DataInputStream in;
        private BufferedOutputStream out;

        public SockIO(SockIOPool pool, String host, int port, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            this.pool = pool;
            this.sock = SockIO.getSocket(host, port, connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host + ":" + port;
        }

        public SockIO(SockIOPool pool, String host, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            if (pool == null) {
                return;
            }
            this.pool = pool;
            String[] ip = host.split(":");
            this.sock = SockIO.getSocket(ip[0], Integer.parseInt(ip[1]), connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host;
        }

        protected static Socket getSocket(String host, int port, int timeout) throws IOException {
            SocketChannel sock = SocketChannel.open();
            sock.socket().connect(new InetSocketAddress(host, port), timeout);
            return sock.socket();
        }

        public SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        public String getHost() {
            return this.host;
        }

        public void trueClose() throws IOException {
            this.trueClose(true);
        }

        public void trueClose(boolean addToDeadPool) throws IOException {
            LOG.debug("++++ Closing socket for real: " + this.toString());
            boolean err = false;
            StringBuilder errMsg = new StringBuilder();
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    LOG.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    LOG.error("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost());
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {
                    LOG.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (addToDeadPool && this.sock != null) {
                this.pool.checkIn(this, false);
            }
            this.in = null;
            this.out = null;
            this.sock = null;
            if (err) {
                throw new IOException(errMsg.toString());
            }
        }

        @Override
        public void close() {
            LOG.debug("++++ marking socket (" + this.toString() + ") as closed and available to return to avail pool");
            this.pool.checkIn(this);
        }

        protected boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        public boolean isAlive() {
            if (!this.isConnected()) {
                return false;
            }
            try {
                this.write("version\r\n".getBytes());
                this.flush();
                this.readLine();
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }

        @Override
        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
            if (bos == null || bos.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return bos.toString().trim();
        }

        @Override
        public void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                    continue;
                }
                if (!eol) continue;
                if (b[0] == 10) break;
                eol = false;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            int count;
            int cnt;
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            for (count = 0; count < b.length; count += cnt) {
                cnt = this.in.read(b, count, b.length - count);
            }
            return count;
        }

        public void flush() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.flush();
        }

        public void write(byte[] b) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.write(b);
        }

        public int hashCode() {
            return this.sock == null ? 0 : this.sock.hashCode();
        }

        public String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        protected void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    LOG.error("++++ closing potentially leaked socket in finalize");
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
            }
        }
    }

    protected static class MaintThread
    extends Thread {
        private SockIOPool pool;
        private long interval = 3000L;
        private boolean stopThread = false;
        private boolean running;

        protected MaintThread(SockIOPool pool) {
            this.pool = pool;
            this.setDaemon(true);
            this.setName("MaintThread");
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void stopThread() {
            this.stopThread = true;
            this.interrupt();
        }

        @Override
        public void run() {
            this.running = true;
            while (!this.stopThread) {
                try {
                    Thread.sleep(this.interval);
                    if (!this.pool.isInitialized()) continue;
                    this.pool.selfMaint();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.running = false;
        }
    }
}

