/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.email.impl;

import com.weicoder.common.log.Logs;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.core.email.base.BaseEmail;
import java.net.URL;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public final class EmailApache
extends BaseEmail {
    public EmailApache(String host, String from, String password, boolean auth, String charset) {
        super(host, from, password, auth, charset);
    }

    @Override
    protected final void sendSimpleEmail(String[] to, String subject, String msg) {
        this.sendEmail((Email)new SimpleEmail(), to, subject, msg);
    }

    @Override
    protected final void sendMultiPartEmail(String[] to, String subject, String msg, String attach) {
        MultiPartEmail email = new MultiPartEmail();
        this.setAttachment(email, attach);
        this.sendEmail((Email)email, to, subject, msg);
    }

    @Override
    protected final void sendHtmlEmail(String[] to, String subject, String msg) {
        this.sendEmail((Email)new HtmlEmail(), to, subject, msg);
    }

    @Override
    protected final void sendHtmlEmail(String[] to, String subject, String msg, String attach) {
        HtmlEmail email = new HtmlEmail();
        this.setAttachment((MultiPartEmail)email, attach);
        this.sendEmail((Email)email, to, subject, msg);
    }

    private void sendEmail(Email email, String[] to, String subject, String msg) {
        try {
            email.setHostName(this.getHost());
            if (this.isAuth()) {
                email.setAuthentication(this.getFrom(), this.getPassword());
            }
            email.setCharset(this.getCharset());
            for (int i = 0; i < to.length; ++i) {
                email.addTo(to[i]);
            }
            email.setFrom(this.getFrom());
            email.setSubject(subject);
            email.setMsg(msg);
            email.send();
        }
        catch (EmailException e) {
            Logs.error((Throwable)e);
        }
    }

    private void setAttachment(MultiPartEmail email, String attach) {
        try {
            if (EmptyUtil.isEmpty((String)attach)) {
                return;
            }
            EmailAttachment attachment = new EmailAttachment();
            if (attach.indexOf("http") == -1) {
                attachment.setPath(attach);
            } else {
                attachment.setURL(new URL(attach));
            }
            attachment.setDisposition("attachment");
            String name = StringUtil.subStringLast((String)attach, (String)"/", (String)".");
            attachment.setDescription(name);
            attachment.setName(name);
            email.attach(attachment);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }
}

