/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.excel.impl;

import com.weicoder.common.io.FileUtil;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.core.excel.base.BaseExcel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelPOI
extends BaseExcel {
    private Workbook workbook;
    private File file;

    public ExcelPOI(File file) {
        this.setIndex(0);
        try {
            this.workbook = EmptyUtil.isEmpty((File)file) ? new XSSFWorkbook() : new XSSFWorkbook((InputStream)FileUtil.getInputStream((File)file));
            this.file = file;
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.workbook = null;
        this.file = null;
    }

    @Override
    public void createSheet(String name, int index) {
        this.workbook.createSheet(name);
        this.setIndex(index);
    }

    @Override
    public void createSheet(String name) {
        this.workbook.createSheet(name);
        this.setIndex(this.workbook.getSheetIndex(name));
    }

    @Override
    public int getColumns(int index) {
        Row row = this.workbook.getSheetAt(index).getRow(0);
        return row == null ? 0 : row.getPhysicalNumberOfCells();
    }

    @Override
    public String readContents(int row, int col) {
        Sheet sheet = this.workbook.getSheetAt(this.getIndex());
        Row hRow = sheet.getRow(row);
        Cell cell = hRow == null ? null : hRow.getCell(col);
        return Conversion.toString((Object)cell);
    }

    @Override
    public int getSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    public int getRows(int num) {
        return this.workbook.getSheetAt(this.getIndex()).getPhysicalNumberOfRows();
    }

    @Override
    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    @Override
    public String getSheetName(int num) {
        return this.workbook.getSheetName(num);
    }

    @Override
    public void write() {
        try (FileOutputStream stream = new FileOutputStream(this.file);){
            this.workbook.write((OutputStream)stream);
            stream.flush();
        }
        catch (IOException e) {
            Logs.error((Throwable)e);
        }
    }

    @Override
    public void writeContents(int row, int col, String content) {
        Cell cell;
        Sheet sheet = null;
        try {
            sheet = this.workbook.getSheetAt(this.getIndex());
        }
        catch (Exception e) {
            sheet = this.workbook.createSheet();
        }
        Row hRow = sheet.getRow(row);
        if (hRow == null) {
            hRow = sheet.createRow(row);
        }
        if ((cell = hRow.getCell(col)) == null) {
            cell = hRow.createCell(col);
        }
        cell.setCellValue(content);
    }
}

