/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.xml.jdom2;

import com.weicoder.common.lang.Lists;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.core.xml.Attribute;
import com.weicoder.core.xml.Document;
import com.weicoder.core.xml.Element;
import com.weicoder.core.xml.jdom2.AttributeJDom2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom2.Content;

public final class ElementJDom2
implements Element {
    private Document doc;
    private org.jdom2.Element element;

    public ElementJDom2(String name) {
        this.element = new org.jdom2.Element(name);
    }

    public ElementJDom2(org.jdom2.Element e) {
        this.element = e;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Element setDocument(Document doc) {
        this.doc = doc;
        return this;
    }

    @Override
    public Element add(Element e) {
        this.element.addContent((Content)((ElementJDom2)e).getElement());
        return this;
    }

    @Override
    public Element addElement(String name, String text) {
        this.element.addContent(name).setText(text);
        return this;
    }

    @Override
    public Element addElement(String name) {
        this.element.addContent(name);
        return this;
    }

    @Override
    public Element add(Attribute a) {
        this.element.setAttribute(((AttributeJDom2)a).getAttribute());
        return this;
    }

    @Override
    public Element addAttribute(String name, String value) {
        this.element.setAttribute(name, value);
        return this;
    }

    @Override
    public Element setName(String name) {
        this.element.setName(name);
        return this;
    }

    @Override
    public List<Element> getElements(String node) {
        return this.getElementList(this.element.getChildren(node));
    }

    @Override
    public List<Attribute> getAttributes() {
        List list = this.element.getAttributes();
        if (EmptyUtil.isEmpty((Collection)list)) {
            return Lists.emptyList();
        }
        int size = list.size();
        List attributes = Lists.newList((int)size);
        for (int i = 0; i < size; ++i) {
            attributes.add(new AttributeJDom2((org.jdom2.Attribute)list.get(i)));
        }
        return attributes;
    }

    @Override
    public List<Element> getElements() {
        return this.getElementList(this.element.getChildren());
    }

    @Override
    public Element getElement(String node) {
        return new ElementJDom2(this.element.getChild(node));
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public String getText() {
        return this.element.getTextTrim();
    }

    public boolean isEmpty() {
        return EmptyUtil.isEmpty((Object)this.element);
    }

    @Override
    public String getAttributeValue(String name) {
        return this.element.getAttributeValue(name);
    }

    @Override
    public Attribute getAttribute(String name) {
        return new AttributeJDom2(this.element.getAttribute(name));
    }

    @Override
    public Element setText(String text) {
        this.element.setText(text);
        return this;
    }

    public org.jdom2.Element getElement() {
        return this.element;
    }

    public void setElement(org.jdom2.Element e) {
        this.element = e;
    }

    public String toString() {
        return this.element.toString();
    }

    private List<Element> getElementList(List<?> list) {
        if (EmptyUtil.isEmpty(list)) {
            Collections.emptyList();
        }
        int size = list.size();
        List lsElement = Lists.newList((int)size);
        for (int i = 0; i < size; ++i) {
            lsElement.add(new ElementJDom2((org.jdom2.Element)list.get(i)));
        }
        return lsElement;
    }
}

