/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.netty.base;

import com.weicoder.socket.Server;
import com.weicoder.socket.params.SocketParams;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public abstract class BaseServer
implements Server {
    private ServerBootstrap bootstrap = new ServerBootstrap();

    public BaseServer() {
        this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1), (EventLoopGroup)new NioEventLoopGroup(SocketParams.POOL));
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        this.bootstrap.childOption(ChannelOption.SO_LINGER, (Object)0);
        this.bootstrap.childOption(ChannelOption.SO_BACKLOG, (Object)1024);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)32768);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.channel(this.channel());
        this.bootstrap.childHandler(this.handler());
        this.bootstrap.localAddress(this.port());
    }

    @Override
    public void bind() {
        this.bootstrap.bind();
    }

    protected abstract ChannelHandler handler();

    protected abstract int port();

    protected Class<? extends ServerChannel> channel() {
        return NioServerSocketChannel.class;
    }
}

