/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.netty.client;

import com.weicoder.common.log.Logs;
import com.weicoder.netty.handler.NettyHandler;
import com.weicoder.netty.session.NettySession;
import com.weicoder.socket.Client;
import com.weicoder.socket.params.SocketParams;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class NettyClient
extends NettySession
implements Client {
    public NettyClient() {
        super("client");
        Bootstrap bootstrap = new Bootstrap();
        NettyHandler handler = new NettyHandler(this.name);
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)false);
        bootstrap.option(ChannelOption.SO_LINGER, (Object)0);
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)32768);
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)handler);
        bootstrap.remoteAddress(SocketParams.CLINET_HOST, SocketParams.CLINET_PORT);
        ChannelFuture future = bootstrap.connect().awaitUninterruptibly();
        this.channel(future.channel());
        if (SocketParams.HEART) {
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
                this.send(SocketParams.HEART_ID, null);
                Logs.trace((String)"testing heart client", (Object[])new Object[0]);
            }, 0L, SocketParams.TIME / 2, TimeUnit.SECONDS);
        }
    }
}

