/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.netty.handler;

import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.netty.session.NettySession;
import com.weicoder.socket.Session;
import com.weicoder.socket.process.Process;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;

@ChannelHandler.Sharable
public class NettyHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private String name;
    private Process process;
    private Map<ChannelId, Session> sessions;

    public NettyHandler(String name) {
        this.name = name;
        this.process = new Process(name);
        this.sessions = Maps.newConcurrentMap();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Session s = this.getSesson(ctx.channel());
        if (s == null) {
            Logs.debug((String)"channel session is null = {}", (Object[])new Object[]{ctx});
        } else {
            Logs.debug((String)"channel is inactive = {}", (Object[])new Object[]{ctx});
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel c = ctx.channel();
        NettySession s = new NettySession(this.name, c);
        this.sessions.put(c.id(), s);
        this.process.connected(s);
        Logs.debug((String)"channel is active = {}", (Object[])new Object[]{ctx});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logs.error((Throwable)cause);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.read(ctx, msg);
    }

    protected void read(ChannelHandlerContext ctx, ByteBuf msg) {
        byte[] data = new byte[msg.readableBytes()];
        msg.readBytes(data);
        this.process.process(this.getSesson(ctx.channel()), data);
    }

    private Session getSesson(Channel channel) {
        Session s = this.sessions.get(channel.id());
        if (s == null) {
            Logs.warn((String)"channel to session is null channel", (Object[])new Object[]{channel});
            channel.close();
            channel.disconnect();
        }
        return s;
    }
}

