/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.netty.handler;

import com.weicoder.netty.handler.NettyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public final class WebSocketHandler
extends NettyHandler {
    private static final String WEBSOCKET_PATH = "ws://%s/websocket";
    private WebSocketServerHandshaker handshaker;

    public WebSocketHandler(String name) {
        super(name);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.http(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.websocket(ctx, (WebSocketFrame)msg);
            ReferenceCountUtil.release((Object)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void http(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.decoderResult().isSuccess()) {
            WebSocketHandler.send(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (req.method() != HttpMethod.GET) {
            WebSocketHandler.send(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(String.format(WEBSOCKET_PATH, req.headers().get((CharSequence)HttpHeaderNames.HOST)), null, true, 0x500000);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            handshaker.handshake(ctx.channel(), req);
        }
    }

    private void websocket(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        this.read(ctx, frame.content());
    }

    private static void send(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (!res.status().equals((Object)HttpResponseStatus.OK)) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || !res.status().equals((Object)HttpResponseStatus.OK)) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

