/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.base;

import com.weicoder.common.W;
import com.weicoder.common.binary.Buffer;
import com.weicoder.common.log.Logs;
import com.weicoder.common.token.TokenBean;
import com.weicoder.common.util.StringUtil;
import com.weicoder.socket.Session;
import com.weicoder.socket.message.Messages;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class BaseSession
implements Session {
    protected String name;
    protected long id;
    protected String ip;
    protected int port;
    protected int heart;
    protected Buffer buffer;
    protected TokenBean token;
    protected Object obj;

    public BaseSession(String name) {
        this.name = name;
        this.buffer = new Buffer();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void send(short id, Object message) {
        this.send(Messages.pack(id, message));
    }

    @Override
    public void send(Object message) {
        this.send(Messages.pack(message));
    }

    @Override
    public void write(short id, Object message) {
        this.write(Messages.pack(id, message));
    }

    @Override
    public void write(Object message) {
        this.write(Messages.pack(message));
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public int getHeart() {
        return this.heart;
    }

    @Override
    public void setHeart(int heart) {
        this.heart = heart;
    }

    @Override
    public void send(byte[] data) {
        this.write(data);
        this.flush();
        Logs.info((String)"name={};socket={};send len={}", (Object[])new Object[]{this.name, this.id, data.length});
    }

    @Override
    public TokenBean getToken() {
        return this.token;
    }

    @Override
    public void setToken(TokenBean token) {
        this.token = token;
    }

    @Override
    public <E> void set(E e) {
        this.obj = e;
    }

    @Override
    public <E> E get() {
        return (E)this.obj;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSession other = (BaseSession)obj;
        return this.id == other.id;
    }

    protected void address(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            this.ip = inet.getHostName();
            this.port = inet.getPort();
        } else {
            String host = address.toString();
            this.ip = StringUtil.subString((String)host, (String)"/", (String)":");
            this.port = W.C.toInt((Object)StringUtil.subString((String)host, (String)":"));
        }
    }
}

