/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.manager;

import com.weicoder.common.U;
import com.weicoder.common.concurrent.ScheduledUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.socket.Session;
import com.weicoder.socket.message.Messages;
import com.weicoder.socket.params.SocketParams;
import java.util.List;
import java.util.Map;

public final class Manager {
    private static Map<Long, Session> registers = Maps.newConcurrentMap();

    public static void register(Session session) {
        registers.put(session.getId(), session);
    }

    public static Session remove(Session session) {
        return Manager.remove(session.getId());
    }

    public static Session remove(long id) {
        return registers.remove(id);
    }

    public static Session get(long id) {
        return registers.get(id);
    }

    public static List<Session> gets(Long ... ids) {
        return Manager.gets(Lists.newList((Object[])ids));
    }

    public static List<Session> gets(List<Long> ids) {
        List list = Lists.newList((int)ids.size());
        ids.forEach(id -> list.add(registers.get(id)));
        return list;
    }

    public static boolean exists(Session session) {
        return registers.containsValue(session);
    }

    public static List<Session> sessions() {
        return Lists.newList(registers.values());
    }

    public static int size() {
        return registers.size();
    }

    public void send(long sid, short id, Object message) {
        Manager.send(id, Messages.pack(id, message));
    }

    public static void send(long sid, byte[] data) {
        Session s = Manager.get(sid);
        if (s != null) {
            s.send(data);
        }
    }

    public void send(List<Long> ids, short id, Object message) {
        Manager.broad(Manager.gets(ids), id, message);
    }

    public static void send(List<Long> ids, byte[] data) {
        Manager.broad(Manager.gets(ids), data);
    }

    public static void broad(short id, Object message) {
        Manager.broad(Manager.sessions(), id, message);
    }

    public static void broad(List<Session> sessions, byte[] data) {
        if (U.E.isEmpty(sessions)) {
            return;
        }
        long curr = System.currentTimeMillis();
        sessions.forEach(session -> session.send(data));
        Logs.debug((String)"manager pool broad end size={} time={}", (Object[])new Object[]{sessions.size(), DateUtil.diff((long)curr)});
    }

    public static void broad(List<Session> sessions, short id, Object message) {
        Manager.broad(sessions, Messages.pack(id, message));
    }

    private Manager() {
    }

    static {
        if (SocketParams.HEART) {
            ScheduledUtil.newRate(() -> {
                int curr = DateUtil.getTime();
                int n = 0;
                for (Session s : Manager.sessions()) {
                    if (curr - s.getHeart() >= SocketParams.TIMEOUT) {
                        Logs.info((String)"heart close session={}", (Object[])new Object[]{s.getId()});
                        registers.remove(s.getId());
                        CloseUtil.close((AutoCloseable[])new AutoCloseable[]{s});
                    }
                    ++n;
                }
                Logs.trace((String)"testing heart num={}", (Object[])new Object[]{n});
            }, (int)0, (int)SocketParams.TIME);
        }
    }
}

