/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.process;

import com.weicoder.common.U;
import com.weicoder.common.binary.Buffer;
import com.weicoder.common.concurrent.ExecutorUtil;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.protobuf.Protobuf;
import com.weicoder.protobuf.ProtobufEngine;
import com.weicoder.socket.Event;
import com.weicoder.socket.Session;
import com.weicoder.socket.annotation.AllHead;
import com.weicoder.socket.annotation.Handler;
import com.weicoder.socket.annotation.Head;
import com.weicoder.socket.manager.Manager;
import com.weicoder.socket.params.SocketParams;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;

public final class Process {
    private static final Log LOG = LogFactory.getLog(Process.class);
    private Map<Short, Object> handlers = Maps.newMap();
    private Map<Short, Method> methods = Maps.newMap();
    private Map<Object, Method> all = Maps.newMap();
    private Event event;
    private String name;

    public Process(String name) {
        this.name = name;
        U.C.list(Handler.class).forEach(c -> {
            Object h = ClassUtil.newInstance((Class)c, (Class[])new Class[0]);
            if (name.equals(h.getClass().getAnnotation(Handler.class).value())) {
                ClassUtil.getPublicMethod((Class)c).forEach(m -> {
                    if (m.isAnnotationPresent(Head.class)) {
                        short id = m.getAnnotation(Head.class).id();
                        this.methods.put(id, (Method)m);
                        this.handlers.put(id, h);
                    } else if (m.isAnnotationPresent(AllHead.class)) {
                        this.all.put(h, (Method)m);
                    }
                });
            }
        });
        this.event = (Event)ClassUtil.newInstance((Class)U.C.from(Event.class, (int)0), (Class[])new Class[0]);
        if (this.event == null) {
            this.event = new EmptyEvent();
        }
    }

    public void connected(Session session) {
        Manager.register(session);
        this.event.connected(session);
        LOG.info("name={};socket conn={};ip={};", new Object[]{this.name, session.getId(), session.getIp()});
    }

    public void closed(Session session) {
        this.event.closed(session);
        Manager.remove(session.getId());
        LOG.info("name={};socket close={};ip={}", new Object[]{this.name, session.getId(), session.getIp()});
    }

    public void process(Session session, byte[] message) {
        long sid = session.getId();
        LOG.debug("name={};socket={};len={};message={}", new Object[]{this.name, sid, message.length, Arrays.toString(message)});
        Buffer buff = session.buffer();
        buff.write(message);
        while (buff.remaining() >= 4) {
            Method m;
            short length = buff.readShort();
            if (length < 2 || length > Short.MAX_VALUE) {
                CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
                LOG.info("name={};error len close id={};len={}", new Object[]{this.name, session.getId(), length});
                return;
            }
            if (buff.remaining() < length) {
                buff.offset(buff.offset() - 2);
                break;
            }
            short id = buff.readShort();
            int len = length - 2;
            byte[] data = new byte[len];
            if (len > 0) {
                buff.read(data);
            }
            if (id == SocketParams.HEART_ID) {
                session.setHeart(DateUtil.getTime());
                this.event.heart(session);
                continue;
            }
            if (U.E.isNotEmpty(this.all)) {
                ExecutorUtil.pool().execute(() -> this.all.forEach((h, m) -> BeanUtil.invoke((Object)h, (Method)m, (Object[])this.getParames((Method)m, data, session))));
            }
            if ((m = this.methods.get(id)) == null) {
                LOG.warn("name={};socket={};handler message discard id={};message len={}", new Object[]{this.name, sid, id, len});
                return;
            }
            LOG.info("name={};socket={};receive len={};id={};method={};time={}", new Object[]{this.name, sid, length, id, m, DateUtil.getTheDate()});
            try {
                long curr = System.currentTimeMillis();
                m.invoke(this.handlers.get(id), this.getParames(m, data, session));
                session.setHeart(DateUtil.getTime());
                LOG.info("name={};socket={};handler end time={}", new Object[]{this.name, sid, System.currentTimeMillis() - curr});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (buff.remaining() != 0) continue;
            buff.clear();
            break;
        }
    }

    private Object[] getParames(Method m, byte[] data, Session session) {
        if (U.E.isEmpty((byte[])data)) {
            return null;
        }
        Parameter[] pars = m.getParameters();
        Object[] params = null;
        if (U.E.isNotEmpty((Object)pars)) {
            params = new Object[pars.length];
            for (int i = 0; i < pars.length; ++i) {
                Parameter p = pars[i];
                Class<?> type = p.getType();
                params[i] = Session.class.isAssignableFrom(type) ? session : (type.isAnnotationPresent(Protobuf.class) ? ProtobufEngine.toBean((byte[])data, type) : Bytes.to((byte[])data, type));
            }
        }
        return params;
    }

    class EmptyEvent
    implements Event {
        EmptyEvent() {
        }

        @Override
        public void connected(Session session) {
        }

        @Override
        public void closed(Session session) {
        }

        @Override
        public void heart(Session session) {
        }
    }
}

