/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.Comparator;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.CalendarFormatter;
import com.sun.msv.datatype.xsd.datetime.CalendarParser;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.PreciseCalendarFormatter;
import com.sun.msv.datatype.xsd.datetime.PreciseCalendarParser;
import java.util.Calendar;
import org.relaxng.datatype.ValidationContext;

abstract class DateTimeBaseType
extends BuiltinAtomicType
implements Comparator {
    private static final long serialVersionUID = 1465669066779112677L;

    protected DateTimeBaseType(String typeName) {
        super(typeName);
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    protected final boolean checkFormat(String content, ValidationContext context) {
        try {
            CalendarParser.parse(this.getFormat(), content);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public final Object _createValue(String content, ValidationContext context) {
        try {
            return PreciseCalendarParser.parse(this.getFormat(), content);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public final String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof IDateTimeValueType)) {
            throw new IllegalArgumentException();
        }
        return PreciseCalendarFormatter.format(this.getFormat(), (IDateTimeValueType)value);
    }

    @Override
    public final Object _createJavaObject(String literal, ValidationContext context) {
        return CalendarParser.parse(this.getFormat(), literal);
    }

    @Override
    public final String serializeJavaObject(Object value, SerializationContext context) {
        if (!(value instanceof Calendar)) {
            throw new IllegalArgumentException();
        }
        return CalendarFormatter.format(this.getFormat(), (Calendar)value);
    }

    @Override
    public Class<Calendar> getJavaObjectType() {
        return Calendar.class;
    }

    protected abstract String getFormat();

    @Override
    public int compare(Object lhs, Object rhs) {
        return ((IDateTimeValueType)lhs).compare((IDateTimeValueType)rhs);
    }

    @Override
    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("pattern") || facetName.equals("enumeration") || facetName.equals("whiteSpace") || facetName.equals("maxInclusive") || facetName.equals("maxExclusive") || facetName.equals("minInclusive") || facetName.equals("minExclusive")) {
            return 0;
        }
        return -2;
    }
}

