/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.Discrete;
import com.sun.msv.datatype.xsd.ListValueType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.util.StringTokenizer;
import org.relaxng.datatype.ValidationContext;

public final class ListType
extends ConcreteType
implements Discrete {
    public final XSDatatypeImpl itemType;
    private static final long serialVersionUID = 1L;

    public ListType(String nsUri, String newTypeName, XSDatatypeImpl itemType) {
        super(nsUri, newTypeName);
        if (itemType.isFinal(2)) {
            throw new RuntimeException(ListType.localize("BadTypeException.InvalidItemType"));
        }
        this.itemType = itemType;
    }

    @Override
    public final String displayName() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return this.itemType.displayName() + "-list";
    }

    @Override
    public final int getVariety() {
        return 2;
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    public boolean isContextDependent() {
        return this.itemType.isContextDependent();
    }

    @Override
    public int getIdType() {
        switch (this.itemType.getIdType()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
        }
        throw new Error();
    }

    @Override
    public final boolean isFinal(int derivationType) {
        if (derivationType == 2) {
            return true;
        }
        return this.itemType.isFinal(derivationType);
    }

    @Override
    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("length") || facetName.equals("minLength") || facetName.equals("maxLength") || facetName.equals("enumeration") || facetName.equals("pattern")) {
            return 0;
        }
        return -2;
    }

    @Override
    protected final boolean checkFormat(String content, ValidationContext context) {
        StringTokenizer tokens = new StringTokenizer(content);
        while (tokens.hasMoreTokens()) {
            if (this.itemType.isValid(tokens.nextToken(), context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object _createValue(String content, ValidationContext context) {
        StringTokenizer tokens = new StringTokenizer(content);
        Object[] values = new Object[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            values[i++] = this.itemType._createValue(tokens.nextToken(), context);
            if (values[i++] != null) continue;
            return null;
        }
        return new ListValueType(values);
    }

    @Override
    public Class<Object[]> getJavaObjectType() {
        return Object[].class;
    }

    @Override
    public final int countLength(Object value) {
        return ((ListValueType)value).values.length;
    }

    @Override
    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof ListValueType)) {
            throw new IllegalArgumentException();
        }
        ListValueType lv = (ListValueType)value;
        StringBuffer r = new StringBuffer();
        for (int i = 0; i < lv.values.length; ++i) {
            if (i != 0) {
                r.append(' ');
            }
            r.append(this.itemType.convertToLexicalValue(lv.values[i], context));
        }
        return r.toString();
    }

    @Override
    protected void _checkValid(String content, ValidationContext context) {
        StringTokenizer tokens = new StringTokenizer(content);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.itemType.checkValid(token, context);
        }
    }
}

