/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import org.relaxng.datatype.ValidationContext;

public class TotalDigitsFacet
extends DataTypeWithLexicalConstraintFacet {
    public final int precision;
    private static final long serialVersionUID = 1L;

    public TotalDigitsFacet(String nsUri, String typeName, XSDatatypeImpl baseType, int _precision, boolean _isFixed) {
        super(nsUri, typeName, baseType, "totalDigits", _isFixed);
        this.precision = _precision;
        DataTypeWithFacet o = baseType.getFacetObject("totalDigits");
        if (o != null && ((TotalDigitsFacet)o).precision < this.precision) {
            throw new RuntimeException(TotalDigitsFacet.localize("LoosenedFacet", "totalDigits", o.displayName()));
        }
    }

    @Override
    protected boolean checkLexicalConstraint(String content) {
        return TotalDigitsFacet.countPrecision(content) <= this.precision;
    }

    @Override
    protected void diagnoseByFacet(String content, ValidationContext context) {
        int cnt = TotalDigitsFacet.countPrecision(content);
        if (cnt <= this.precision) {
            return;
        }
        throw new RuntimeException(TotalDigitsFacet.localize("DataTypeErrorDiagnosis.TooMuchPrecision", cnt, this.precision));
    }

    protected static int countPrecision(String literal) {
        int len = literal.length();
        boolean skipMode = true;
        boolean seenDot = false;
        int count = 0;
        int trailingZero = 0;
        for (int i = 0; i < len; ++i) {
            char ch = literal.charAt(i);
            if (ch == '.') {
                skipMode = false;
                seenDot = true;
            }
            if (skipMode) {
                if ('1' > ch || ch > '9') continue;
                ++count;
                skipMode = false;
                continue;
            }
            trailingZero = seenDot && ch == '0' ? ++trailingZero : 0;
            if ('0' > ch || ch > '9') continue;
            ++count;
        }
        return count - trailingZero;
    }
}

