/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;

public class JavaClassConverter
extends AbstractSingleValueConverter {
    private Mapper mapper;

    public JavaClassConverter(ClassLoaderReference classLoaderReference) {
        this(new DefaultMapper(classLoaderReference));
    }

    public JavaClassConverter(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    protected JavaClassConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return Class.class.equals((Object)clazz);
    }

    @Override
    public String toString(Object obj) {
        return this.mapper.serializedClass((Class)obj);
    }

    @Override
    public Object fromString(String str) {
        try {
            return this.mapper.realClass(str);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load java class " + str, e.getCause());
        }
    }
}

