/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.time;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;

public class ZoneIdConverter
implements SingleValueConverter {
    @Override
    public boolean canConvert(Class type) {
        return type != null && ZoneId.class.isAssignableFrom(type);
    }

    @Override
    public ZoneId fromString(String str) {
        try {
            return ZoneId.of(str);
        }
        catch (ZoneRulesException e) {
            throw new RuntimeException("Not a valid zone id", e);
        }
        catch (DateTimeException e) {
            throw new RuntimeException("Cannot parse value as zone id", e);
        }
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        ZoneId zoneId = (ZoneId)obj;
        return zoneId.getId();
    }
}

