/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Iterator;

public class TreeMarshaller
implements MarshallingContext {
    protected HierarchicalStreamWriter writer;
    protected ConverterLookup converterLookup;
    private Mapper mapper;
    private ObjectIdDictionary parentObjects = new ObjectIdDictionary();
    private DataHolder dataHolder;

    public TreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        this.writer = writer;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    @Override
    public void convertAnother(Object item) {
        this.convertAnother(item, null);
    }

    @Override
    public void convertAnother(Object item, Converter converter) {
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(item.getClass());
        } else if (!converter.canConvert(item.getClass())) {
            RuntimeException e = new RuntimeException("Explicit selected converter cannot handle item");
            throw e;
        }
        this.convert(item, converter);
    }

    protected void convert(Object item, Converter converter) {
        if (this.parentObjects.containsId(item)) {
            CircularReferenceException e = new CircularReferenceException("Recursive reference to parent object");
            throw e;
        }
        this.parentObjects.associateId(item, "");
        converter.marshal(item, this.writer, this);
        this.parentObjects.removeId(item);
    }

    public void start(Object item, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (item == null) {
            this.writer.startNode(this.mapper.serializedClass(null));
            this.writer.endNode();
        } else {
            ExtendedHierarchicalStreamWriterHelper.startNode(this.writer, this.mapper.serializedClass(item.getClass()), item.getClass());
            this.convertAnother(item);
            this.writer.endNode();
        }
    }

    @Override
    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    @Override
    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    public static class CircularReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CircularReferenceException(String msg) {
            super(msg);
        }
    }
}

