/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;

public class JDom2Reader
extends AbstractDocumentReader {
    private Element currentElement;

    public JDom2Reader(Element root) {
        super(root);
    }

    public JDom2Reader(Document document) {
        super(document.getRootElement());
    }

    public JDom2Reader(Element root, NameCoder nameCoder) {
        super((Object)root, nameCoder);
    }

    public JDom2Reader(Document document, NameCoder nameCoder) {
        super((Object)document.getRootElement(), nameCoder);
    }

    @Override
    protected void reassignCurrentElement(Object current) {
        this.currentElement = (Element)current;
    }

    @Override
    protected Object getParent() {
        return this.currentElement.getParentElement();
    }

    @Override
    protected Object getChild(int index) {
        return this.currentElement.getChildren().get(index);
    }

    @Override
    protected int getChildCount() {
        return this.currentElement.getChildren().size();
    }

    @Override
    public String getNodeName() {
        return this.decodeNode(this.currentElement.getName());
    }

    @Override
    public String getValue() {
        return this.currentElement.getText();
    }

    @Override
    public String getAttribute(String name) {
        return this.currentElement.getAttributeValue(this.encodeAttribute(name));
    }

    @Override
    public String getAttribute(int index) {
        return this.currentElement.getAttributes().get(index).getValue();
    }

    @Override
    public int getAttributeCount() {
        return this.currentElement.getAttributes().size();
    }

    @Override
    public String getAttributeName(int index) {
        return this.decodeAttribute(this.currentElement.getAttributes().get(index).getQualifiedName());
    }

    @Override
    public String peekNextChild() {
        List<Element> list = this.currentElement.getChildren();
        if (null == list || list.isEmpty()) {
            return null;
        }
        return this.decodeNode(list.get(0).getName());
    }
}

