/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.mapper.Mapper;

public class DefaultMapper
implements Mapper {
    private static String XSTREAM_PACKAGE_ROOT;
    private final ClassLoaderReference classLoaderReference;

    public DefaultMapper(ClassLoaderReference classLoaderReference) {
        this.classLoaderReference = classLoaderReference;
    }

    public DefaultMapper(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    @Override
    public String serializedClass(Class type) {
        return type.getName();
    }

    @Override
    public Class realClass(String elementName) {
        Class resultingClass = Primitives.primitiveType(elementName);
        if (resultingClass != null) {
            return resultingClass;
        }
        try {
            ClassLoader classLoader;
            boolean initialize = true;
            if (elementName.startsWith(XSTREAM_PACKAGE_ROOT)) {
                classLoader = DefaultMapper.class.getClassLoader();
            } else {
                classLoader = this.classLoaderReference.getReference();
                initialize = elementName.charAt(0) == '[';
            }
            return Class.forName(elementName, initialize, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(elementName);
        }
    }

    @Override
    public Class defaultImplementationOf(Class type) {
        return type;
    }

    @Override
    public String aliasForAttribute(String attribute) {
        return attribute;
    }

    @Override
    public String attributeForAlias(String alias) {
        return alias;
    }

    @Override
    public String aliasForSystemAttribute(String attribute) {
        return attribute;
    }

    @Override
    public boolean isImmutableValueType(Class type) {
        return false;
    }

    @Override
    public boolean isReferenceable(Class type) {
        return true;
    }

    @Override
    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        return null;
    }

    @Override
    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        return null;
    }

    @Override
    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        return null;
    }

    @Override
    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return true;
    }

    @Override
    public boolean isIgnoredElement(String name) {
        return false;
    }

    public String lookupName(Class type) {
        return this.serializedClass(type);
    }

    public Class lookupType(String elementName) {
        return this.realClass(elementName);
    }

    @Override
    public String serializedMember(Class type, String memberName) {
        return memberName;
    }

    @Override
    public String realMember(Class type, String serialized) {
        return serialized;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(String name) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(String fieldName, Class type) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(Class type) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        return null;
    }

    @Override
    public Converter getLocalConverter(Class definedIn, String fieldName) {
        return null;
    }

    @Override
    public Mapper lookupMapperOfType(Class type) {
        return null;
    }

    @Override
    public String aliasForAttribute(Class definedIn, String fieldName) {
        return fieldName;
    }

    @Override
    public String attributeForAlias(Class definedIn, String alias) {
        return alias;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type) {
        return null;
    }

    static {
        String packageName = DefaultMapper.class.getName();
        int idx = packageName.indexOf(".xstream.");
        XSTREAM_PACKAGE_ROOT = idx > 0 ? packageName.substring(0, idx + 9) : ".N/A";
    }
}

