/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpp;

import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.gjt.xpp.XmlStartTag;

public class ProxyXmlStartTag
implements XmlStartTag {
    private Element element;
    private DocumentFactory factory = DocumentFactory.getInstance();

    public ProxyXmlStartTag() {
    }

    public ProxyXmlStartTag(Element element) {
        this.element = element;
    }

    @Override
    public void resetStartTag() {
        this.element = null;
    }

    @Override
    public int getAttributeCount() {
        return this.element != null ? this.element.attributeCount() : 0;
    }

    @Override
    public String getAttributeNamespaceUri(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getAttributeLocalName(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getName();
        }
        return null;
    }

    @Override
    public String getAttributePrefix(int index) {
        String prefix;
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null && (prefix = attribute.getNamespacePrefix()) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    @Override
    public String getAttributeRawName(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getQualifiedName();
        }
        return null;
    }

    @Override
    public String getAttributeValue(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public String getAttributeValueFromRawName(String rawName) {
        if (this.element != null) {
            Iterator<Attribute> iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute = iter.next();
                if (!rawName.equals(attribute.getQualifiedName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    @Override
    public String getAttributeValueFromName(String namespaceURI, String localName) {
        if (this.element != null) {
            Iterator<Attribute> iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute = iter.next();
                if (!namespaceURI.equals(attribute.getNamespaceURI()) || !localName.equals(attribute.getName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    @Override
    public boolean isAttributeNamespaceDeclaration(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return "xmlns".equals(attribute.getNamespacePrefix());
        }
        return false;
    }

    @Override
    public void addAttribute(String namespaceURI, String localName, String rawName, String value) {
        QName qname = QName.get(rawName, namespaceURI);
        this.element.addAttribute(qname, value);
    }

    @Override
    public void addAttribute(String namespaceURI, String localName, String rawName, String value, boolean isNamespaceDeclaration) {
        if (isNamespaceDeclaration) {
            String prefix = "";
            int idx = rawName.indexOf(58);
            if (idx > 0) {
                prefix = rawName.substring(0, idx);
            }
            this.element.addNamespace(prefix, namespaceURI);
        } else {
            QName qname = QName.get(rawName, namespaceURI);
            this.element.addAttribute(qname, value);
        }
    }

    @Override
    public void ensureAttributesCapacity(int minCapacity) {
        if (this.element instanceof AbstractElement) {
            AbstractElement elementImpl = (AbstractElement)this.element;
            elementImpl.ensureAttributesCapacity(minCapacity);
        }
    }

    public void removeAtttributes() {
        if (this.element != null) {
            this.element.setAttributes(new ArrayList<Attribute>());
        }
    }

    @Override
    public String getLocalName() {
        return this.element.getName();
    }

    @Override
    public String getNamespaceUri() {
        return this.element.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.element.getNamespacePrefix();
    }

    @Override
    public String getRawName() {
        return this.element.getQualifiedName();
    }

    @Override
    public void modifyTag(String namespaceURI, String lName, String rawName) {
        this.element = this.factory.createElement(rawName, namespaceURI);
    }

    @Override
    public void resetTag() {
        this.element = null;
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean removeAttributeByName(String arg0, String arg1) {
        return false;
    }

    @Override
    public boolean removeAttributeByRawName(String arg0) {
        return false;
    }

    @Override
    public void removeAttributes() {
    }
}

