/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultBinaryExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.NodeComparator;
import org.jaxen.expr.UnionExpr;

public class DefaultUnionExpr
extends DefaultBinaryExpr
implements UnionExpr {
    private static final long serialVersionUID = 7629142718276852707L;

    public DefaultUnionExpr(Expr lhs, Expr rhs) {
        super(lhs, rhs);
    }

    @Override
    public String getOperator() {
        return "|";
    }

    @Override
    public String toString() {
        return "[(DefaultUnionExpr): " + this.getLHS() + ", " + this.getRHS() + "]";
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        ArrayList results = new ArrayList();
        try {
            List lhsResults = (List)this.getLHS().evaluate(context);
            List rhsResults = (List)this.getRHS().evaluate(context);
            HashSet unique = new HashSet();
            results.addAll(lhsResults);
            unique.addAll(lhsResults);
            for (Object each : rhsResults) {
                if (unique.contains(each)) continue;
                results.add(each);
                unique.add(each);
            }
            Collections.sort(results, new NodeComparator(context.getNavigator()));
            return results;
        }
        catch (ClassCastException e) {
            throw new JaxenException(this.getText() + "Unions are only allowed over node-sets");
        }
    }
}

