/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.beans;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.contrib.beans.DateUtils;

public class StringConverter {
    protected Map<Class<?>, Factory> factories = new HashMap();
    protected static Class<?>[] argString = new Class[]{String.class};

    public StringConverter() {
        try {
            this.factories.put(Class.forName("java.util.Date"), new DateFactory());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setFactory(Class<?> type, Factory factory) {
        this.factories.put(type, factory);
    }

    public Object parse(String string, Class<?> type) {
        if (type == String.class) {
            return string;
        }
        Factory factory = this.factories.get(type);
        if (factory != null) {
            return factory.instantiate(string);
        }
        if (type == Short.TYPE) {
            type = Short.class;
        }
        if (type == Integer.TYPE) {
            type = Integer.class;
        }
        if (type == Long.TYPE) {
            type = Long.class;
        }
        if (type == Boolean.TYPE) {
            type = Boolean.class;
        }
        if (type == Character.TYPE) {
            type = Character.class;
        }
        if (type == Byte.TYPE) {
            type = Byte.class;
        }
        try {
            Constructor<Object> c = type.getConstructor(argString);
            if (c != null) {
                return c.newInstance(string);
            }
        }
        catch (NoSuchMethodException c) {
        }
        catch (Exception e) {
            System.err.println("Couldn't instantiate " + type + "(" + string + ")");
            e.printStackTrace();
        }
        return null;
    }

    public static class DateFactory
    implements Factory {
        @Override
        public Object instantiate(String string) {
            return DateUtils.parseDate(string);
        }
    }

    public static interface Factory {
        public Object instantiate(String var1);
    }
}

