/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.net.URISyntaxException;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.Namespace;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JNamespaceAware;
import org.jdom2.contrib.dom.JParent;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

final class JAttribute
extends JNamespaceAware
implements Attr {
    final Attribute attribute;

    public JAttribute(JDocument topdoc, JParent parent, Attribute attribute, Namespace[] nstack) {
        super(topdoc, parent, (short)2, nstack);
        this.attribute = attribute;
    }

    @Override
    public final Object getWrapped() {
        return this.attribute;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public NodeList getChildNodes() {
        return EMPTYLIST;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return this.attribute.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.attribute.getNamespacePrefix();
    }

    @Override
    public String getLocalName() {
        return this.attribute.getName();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        try {
            return this.attribute.getParent().getXMLBaseURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to process URI", e);
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        return "";
    }

    @Override
    public String getName() {
        return this.attribute.getQualifiedName();
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.attribute.getValue();
    }

    @Override
    public Element getOwnerElement() {
        return (Element)this.getParentNode();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return TYPEINFO;
    }

    @Override
    public boolean isId() {
        return this.attribute.getAttributeType() == AttributeType.ID;
    }

    @Override
    public void setValue(String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }
}

