/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.contrib.dom.JAttribute;
import org.jdom2.contrib.dom.JCDATA;
import org.jdom2.contrib.dom.JComment;
import org.jdom2.contrib.dom.JContent;
import org.jdom2.contrib.dom.JDOMConfiguration;
import org.jdom2.contrib.dom.JDOMImplementation;
import org.jdom2.contrib.dom.JDocType;
import org.jdom2.contrib.dom.JElement;
import org.jdom2.contrib.dom.JEntityRef;
import org.jdom2.contrib.dom.JNamespaceAware;
import org.jdom2.contrib.dom.JNodeList;
import org.jdom2.contrib.dom.JParent;
import org.jdom2.contrib.dom.JProcessingInstruction;
import org.jdom2.contrib.dom.JSimpleContent;
import org.jdom2.contrib.dom.JText;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;
import org.jdom2.util.NamespaceStack;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JDocument
extends JParent
implements org.w3c.dom.Document {
    private static final JDOMImplementation implementation = new JDOMImplementation();
    private static final JDOMConfiguration configuration = new JDOMConfiguration();
    private boolean allscanned = false;
    private final JElement root;
    private final JDocType doctype;
    private final IdentityHashMap<Object, JNamespaceAware> mapped = new IdentityHashMap();
    private final HashMap<String, JElement> idmap = new HashMap();

    public JDocument(Document shadow) {
        super(null, null, shadow, (short)9, new Namespace[]{Namespace.NO_NAMESPACE, Namespace.XML_NAMESPACE});
        if (shadow == null) {
            this.root = null;
            this.doctype = null;
        } else {
            JNamespaceAware[] kids = this.checkKids();
            JDocType dt = null;
            JElement je = null;
            for (JNamespaceAware n : kids) {
                if (n.getNodeType() == 10) {
                    dt = (JDocType)n;
                }
                if (n.getNodeType() != 1) continue;
                je = (JElement)n;
            }
            this.root = je;
            this.doctype = dt;
        }
    }

    public void scanAll() {
        if (this.allscanned) {
            return;
        }
        if (this.shadow == null) {
            this.allscanned = true;
            return;
        }
        this.allscanned = true;
        IteratorIterable<Element> it = this.shadow.getDescendants(Filters.element());
        while (it.hasNext()) {
            this.find((Element)it.next());
        }
    }

    public JElement find(Element emt) {
        JNamespaceAware me = this.mapped.get(emt);
        if (me != null) {
            return (JElement)me;
        }
        Element jp = emt.getParentElement();
        if (jp == null) {
            Document jd = emt.getDocument();
            if (jd != this.shadow) {
                throw new DOMException(4, "Element is not part of our document");
            }
            NamespaceStack ns = new NamespaceStack(this.scope);
            ns.push(emt);
            ArrayList<Namespace> added = new ArrayList<Namespace>();
            for (Namespace ans : ns.addedForward()) {
                added.add(ans);
            }
            JElement je = new JElement(this, (JParent)this, (Parent)emt, ns.getScope(), added.toArray(new Namespace[added.size()]));
            this.mapped.put(emt, je);
            this.checkID(je);
            return je;
        }
        JElement pnt = this.find(jp);
        NamespaceStack ns = new NamespaceStack(pnt.scope);
        ns.push(emt);
        ArrayList<Namespace> added = new ArrayList<Namespace>();
        for (Namespace ans : ns.addedForward()) {
            added.add(ans);
        }
        JElement ret = new JElement(this, (JParent)pnt, (Parent)emt, ns.getScope(), added.toArray(new Namespace[added.size()]));
        this.mapped.put(emt, ret);
        this.checkID(ret);
        return ret;
    }

    public JAttribute find(Attribute att) {
        JNamespaceAware me = this.mapped.get(att);
        if (me != null) {
            return (JAttribute)me;
        }
        Element jp = att.getParent();
        JDocument pnt = jp == null ? this : this.find(jp);
        NamespaceStack ns = jp == null ? new NamespaceStack() : new NamespaceStack(this.find((Element)jp).scope);
        ns.push(att);
        JAttribute ret = new JAttribute(this, (JParent)pnt, att, ns.getScope());
        this.mapped.put(att, ret);
        return ret;
    }

    private JContent findContent(Content content) {
        JNamespaceAware me = this.mapped.get(content);
        if (me != null) {
            return (JContent)me;
        }
        Element jp = content.getParentElement();
        JDocument pnt = jp == null ? this : this.find(jp);
        JSimpleContent ret = null;
        switch (content.getCType()) {
            case CDATA: {
                ret = new JCDATA(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            case Comment: {
                ret = new JComment(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            case DocType: {
                ret = new JDocType(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            case EntityRef: {
                ret = new JEntityRef(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            case ProcessingInstruction: {
                ret = new JProcessingInstruction(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            case Text: {
                ret = new JText(this, (JParent)pnt, content, pnt.scope);
                break;
            }
            default: {
                throw new IllegalStateException("Other types should have their own methods.");
            }
        }
        this.mapped.put(content, ret);
        return ret;
    }

    public JCDATA find(CDATA content) {
        return (JCDATA)this.findContent(content);
    }

    public JDocType find(DocType content) {
        return (JDocType)this.findContent(content);
    }

    public JProcessingInstruction find(ProcessingInstruction content) {
        return (JProcessingInstruction)this.findContent(content);
    }

    public JEntityRef find(EntityRef content) {
        return (JEntityRef)this.findContent(content);
    }

    public JComment find(Comment content) {
        return (JComment)this.findContent(content);
    }

    public JText find(Text content) {
        return (JText)this.findContent(content);
    }

    private void checkID(JElement je) {
        Element emt = (Element)je.shadow;
        if (emt.hasAttributes()) {
            for (Attribute a : emt.getAttributes()) {
                if (a.getAttributeType() != AttributeType.ID || this.idmap.put(a.getValue(), je) == null) continue;
                throw new DOMException(11, "Multiple elements with id " + a.getValue());
            }
        }
    }

    @Override
    public DocumentType getDoctype() {
        return this.doctype;
    }

    @Override
    public org.w3c.dom.Element getDocumentElement() {
        return this.root;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.getElementsByTagName(this.shadow, tagname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagNameNS(this.shadow, namespaceURI, localName);
    }

    NodeList getElementsByTagName(Parent xshadow, String tagname) {
        if (tagname == null) {
            return EMPTYLIST;
        }
        ArrayList<JElement> enodes = new ArrayList<JElement>();
        boolean alltags = "*".equals(tagname);
        IteratorIterable<Element> it = xshadow.getDescendants(Filters.element());
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!alltags && !tagname.equals(e.getQualifiedName())) continue;
            enodes.add(this.find(e));
        }
        return new JNodeList(enodes);
    }

    NodeList getElementsByTagNameNS(Parent xshadow, String namespaceURI, String localName) {
        if (localName == null) {
            return EMPTYLIST;
        }
        if (namespaceURI == null) {
            return EMPTYLIST;
        }
        boolean alluri = "*".equals(namespaceURI);
        boolean allname = "*".equals(localName);
        ArrayList<JElement> enodes = new ArrayList<JElement>();
        IteratorIterable<Element> it = xshadow.getDescendants(Filters.element());
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!allname && !localName.equals(e.getName()) || !alluri && !namespaceURI.equals(e.getNamespaceURI())) continue;
            enodes.add(this.find(e));
        }
        return new JNodeList(enodes);
    }

    @Override
    public org.w3c.dom.Element getElementById(String elementId) {
        this.scanAll();
        return this.idmap.get(elementId);
    }

    @Override
    public String getDocumentURI() {
        return this.shadow == null ? null : ((Document)this.shadow).getBaseURI();
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getBaseURI() {
        return this.shadow == null ? null : ((Document)this.shadow).getBaseURI();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public final DOMImplementation getImplementation() {
        return implementation;
    }

    @Override
    public final DOMConfiguration getDomConfig() {
        return configuration;
    }

    @Override
    public final boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public final void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public final void setDocumentURI(String documentURI) {
    }

    @Override
    public final void normalizeDocument() {
    }

    @Override
    public final Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node adoptNode(Node source) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final org.w3c.dom.Element createElement(String tagName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final org.w3c.dom.Text createTextNode(String data) {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final org.w3c.dom.Comment createComment(String data) {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final CDATASection createCDATASection(String data) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final org.w3c.dom.ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Attr createAttribute(String name) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final org.w3c.dom.Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }
}

