/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.net.URISyntaxException;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JNamespace;
import org.jdom2.contrib.dom.JParent;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

class JElement
extends JParent
implements org.w3c.dom.Element {
    private NamedNodeMap attmap = null;
    private final Namespace[] nsdec;

    public JElement(JDocument topdoc, JParent parent, Parent shadow, Namespace[] nstack, Namespace[] ndec) {
        super(topdoc, parent, shadow, (short)1, nstack);
        this.nsdec = ndec;
    }

    @Override
    public final String getNodeName() {
        return this.getTagName();
    }

    @Override
    public final String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        if (this.attmap == null) {
            Element emt = (Element)this.shadow;
            if (emt.hasAttributes() || this.nsdec.length > 0) {
                int i;
                List<Attribute> list = emt.getAttributes();
                int sz = list.size();
                Attr[] ja = new Attr[sz + this.nsdec.length];
                for (i = 0; i < this.nsdec.length; ++i) {
                    ja[i] = new JNamespace(this.topdoc, this, this.nsdec[i], this.scope);
                }
                for (i = 0; i < sz; ++i) {
                    ja[this.nsdec.length + i] = this.topdoc.find(list.get(i));
                }
                this.attmap = new AttMap(ja);
            } else {
                this.attmap = EMPTYMAP;
            }
        }
        return this.attmap;
    }

    @Override
    public final String getNamespaceURI() {
        return ((Element)this.shadow).getNamespaceURI();
    }

    @Override
    public final String getPrefix() {
        return ((Element)this.shadow).getNamespacePrefix();
    }

    @Override
    public final String getLocalName() {
        return ((Element)this.shadow).getName();
    }

    @Override
    public final String getBaseURI() {
        try {
            return ((Element)this.shadow).getXMLBaseURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Broken base URI references.", e);
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        IteratorIterable<Text> it = ((Element)this.shadow).getDescendants(Filters.fclass(Text.class));
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(((Text)it.next()).getText());
        }
        return sb.toString();
    }

    @Override
    public String getTagName() {
        return ((Element)this.shadow).getQualifiedName();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.topdoc.getElementsByTagName(this.shadow, tagname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.topdoc.getElementsByTagNameNS(this.shadow, namespaceURI, localName);
    }

    @Override
    public final boolean hasAttributes() {
        return ((Element)this.shadow).hasAttributes();
    }

    @Override
    public boolean hasAttribute(String name) {
        Attribute att = ((Element)this.shadow).getAttribute(name);
        return att != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attribute att = ((Element)this.shadow).getAttribute(localName, Namespace.getNamespace(namespaceURI));
        return att != null;
    }

    @Override
    public String getAttribute(String name) {
        Attribute att = ((Element)this.shadow).getAttribute(name);
        return att == null ? "" : att.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attribute att = ((Element)this.shadow).getAttribute(localName, Namespace.getNamespace(namespaceURI));
        return att == null ? "" : att.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.getAttributes().getNamedItem(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (Attr)this.getAttributes().getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    private final class AttMap
    implements NamedNodeMap {
        private final Attr[] atts;

        public AttMap(Attr[] atts) {
            this.atts = atts;
        }

        @Override
        public Node item(int index) {
            if (index < 0 || index >= this.atts.length) {
                return null;
            }
            return this.atts[index];
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
            if (namespaceURI == null || localName == null) {
                return null;
            }
            for (int i = 0; i < this.atts.length; ++i) {
                if (!namespaceURI.equals(this.atts[i].getNamespaceURI()) || !localName.equals(this.atts[i].getLocalName())) continue;
                return this.atts[i];
            }
            return null;
        }

        @Override
        public Node getNamedItem(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < this.atts.length; ++i) {
                if (!name.equals(this.atts[i].getName())) continue;
                return this.atts[i];
            }
            return null;
        }

        @Override
        public int getLength() {
            return this.atts.length;
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }
    }
}

