/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.util.ArrayList;
import java.util.HashMap;
import org.jdom2.contrib.dom.JAttribute;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JParent;
import org.jdom2.contrib.dom.Wrapper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

abstract class JNode
implements Node,
Wrapper {
    protected static final TypeInfo TYPEINFO = new TypeInfo(){

        @Override
        public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
            return false;
        }

        @Override
        public String getTypeNamespace() {
            return "http://www.w3.org/TR/REC-xml";
        }

        @Override
        public String getTypeName() {
            return null;
        }
    };
    protected static final NodeList EMPTYLIST = new NodeList(){

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    };
    protected static final NamedNodeMap EMPTYMAP = new NamedNodeMap(){

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return null;
        }

        @Override
        public Node getNamedItem(String name) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    };
    private final short nodetype;
    protected final JDocument topdoc;
    protected final JParent parent;
    private HashMap<String, Object> userdata;

    JNode(JDocument topdoc, JParent parent, short nodetype) {
        this.topdoc = topdoc == null ? (JDocument)this : topdoc;
        this.nodetype = nodetype;
        this.parent = parent;
    }

    protected boolean detailEquals(JNode other) {
        return true;
    }

    @Override
    public final Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPreviousSibling(this);
    }

    @Override
    public final Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNextSibling(this);
    }

    @Override
    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userdata == null) {
            this.userdata = new HashMap();
        }
        return this.userdata.put(key, data);
    }

    @Override
    public final Object getUserData(String key) {
        if (this.userdata == null) {
            return null;
        }
        return this.userdata.get(key);
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public final Node getParentNode() {
        return this.parent;
    }

    @Override
    public final short getNodeType() {
        return this.nodetype;
    }

    @Override
    public final Document getOwnerDocument() {
        return this.topdoc;
    }

    @Override
    public final short compareDocumentPosition(Node other) throws DOMException {
        if (other instanceof JNode) {
            JNode their = (JNode)other;
            if (their == this) {
                return 0;
            }
            if (their.topdoc == this.topdoc) {
                ArrayList<JNode> ancestry = new ArrayList<JNode>();
                ancestry.add(their);
                JParent p = their.parent;
                while (p != null) {
                    if (p == this) {
                        return 20;
                    }
                    ancestry.add(p);
                    p = p.parent;
                }
                p = this.parent;
                JNode k = this;
                int alen = ancestry.size();
                while (p != null) {
                    for (int apos = 0; apos < alen; ++apos) {
                        if (p != ancestry.get(apos)) continue;
                        int sibpos = apos - 1;
                        if (sibpos < 0) {
                            return 10;
                        }
                        JNode sibling = (JNode)ancestry.get(sibpos);
                        JParent prnt = p;
                        if (sibling instanceof JAttribute) {
                            NamedNodeMap nnm = prnt.getAttributes();
                            for (int i = nnm.getLength() - 1; i >= 0; --i) {
                                Node n = nnm.item(i);
                                if (n == sibling) {
                                    return 4;
                                }
                                if (n != k) continue;
                                return 2;
                            }
                        } else {
                            for (int i = prnt.getLength() - 1; i >= 0; --i) {
                                Node n = prnt.item(i);
                                if (n == sibling) {
                                    return 4;
                                }
                                if (n != k) continue;
                                return 2;
                            }
                        }
                        throw new IllegalStateException("Sibling nodes appear not to be siblings?");
                    }
                    k = p;
                    p = p.parent;
                }
            }
            return 1;
        }
        throw new DOMException(9, "Not same Document Model");
    }

    @Override
    public final boolean isEqualNode(Node other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        if (this.isSameNode(other)) {
            return true;
        }
        if (JNode.areSame(this.getNodeName(), other.getNodeName()) && JNode.areSame(this.getLocalName(), other.getLocalName()) && JNode.areSame(this.getNamespaceURI(), other.getNamespaceURI()) && JNode.areSame(this.getPrefix(), other.getPrefix()) && JNode.areSame(this.getNodeValue(), other.getNodeValue())) {
            return this.detailEquals((JNode)other);
        }
        return false;
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public final Node cloneNode(boolean deep) {
        return this;
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final void setTextContent(String textContent) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    @Override
    public final void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    protected static final boolean areSame(String a, String b) {
        if (b == null) {
            return a == null;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }
}

