/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JNamespaceAware;
import org.jdom2.contrib.dom.JNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class JParent
extends JNamespaceAware
implements NodeList {
    private JNamespaceAware[] kids = null;
    protected final Parent shadow;

    public JParent(JDocument topdoc, JParent parent, Parent shadow, short nodetype, Namespace[] nstack) {
        super(topdoc, parent, nodetype, nstack);
        this.shadow = shadow;
    }

    @Override
    public final Object getWrapped() {
        return this.shadow;
    }

    private final JNamespaceAware hydrate(Content k) {
        switch (k.getCType()) {
            case CDATA: {
                return this.topdoc.find((CDATA)k);
            }
            case Comment: {
                return this.topdoc.find((Comment)k);
            }
            case DocType: {
                return this.topdoc.find((DocType)k);
            }
            case Element: {
                return this.topdoc.find((Element)k);
            }
            case EntityRef: {
                return this.topdoc.find((EntityRef)k);
            }
            case ProcessingInstruction: {
                return this.topdoc.find((ProcessingInstruction)k);
            }
            case Text: {
                return this.topdoc.find((Text)k);
            }
        }
        throw new IllegalStateException("Unexpected content " + k);
    }

    protected final JNamespaceAware[] checkKids() {
        if (this.kids != null) {
            return this.kids;
        }
        if (this.shadow == null) {
            this.kids = new JNamespaceAware[0];
            return this.kids;
        }
        List<Content> content = this.shadow.getContent();
        this.kids = new JNamespaceAware[content.size()];
        for (int i = 0; i < this.kids.length; ++i) {
            this.kids[i] = this.hydrate(content.get(i));
        }
        return this.kids;
    }

    protected final JNode getPreviousSibling(JNode jNode) {
        this.checkKids();
        for (int i = 0; i < this.kids.length; ++i) {
            if (this.kids[i] != jNode) continue;
            return i > 0 ? this.kids[i - 1] : null;
        }
        return null;
    }

    protected final JNode getNextSibling(JNode jNode) {
        this.checkKids();
        for (int i = 0; i < this.kids.length; ++i) {
            if (this.kids[i] != jNode) continue;
            return i < this.kids.length - 1 ? this.kids[i + 1] : null;
        }
        return null;
    }

    @Override
    public final boolean hasChildNodes() {
        this.checkKids();
        return this.kids.length > 0;
    }

    @Override
    public final NodeList getChildNodes() {
        this.checkKids();
        return this;
    }

    @Override
    public final Node getFirstChild() {
        this.checkKids();
        return this.kids.length > 0 ? this.kids[0] : null;
    }

    @Override
    public final Node getLastChild() {
        this.checkKids();
        return this.kids.length > 0 ? this.kids[this.kids.length - 1] : null;
    }

    @Override
    public final Node item(int index) {
        this.checkKids();
        return index >= 0 && index < this.kids.length ? this.kids[index] : null;
    }

    @Override
    public final int getLength() {
        this.checkKids();
        return this.kids.length;
    }
}

