/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.helpers;

import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.filter.Filters;

@Deprecated
public class XPathHelper {
    public static String getPathString(Element to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, Element to) throws JDOMException {
        XPathHelper.checkPathStringArguments(from, to);
        if (to == from) {
            return "node()";
        }
        return XPathHelper.getElementPath(from, to, true).toString();
    }

    public static String getPathString(Attribute to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, Attribute to) throws JDOMException {
        XPathHelper.checkPathStringArguments(from, to);
        if (to == from) {
            return "node()";
        }
        StringBuilder path = XPathHelper.getElementPath(from, to.getParent(), false);
        path.append('@').append(to.getName()).toString();
        return path.toString();
    }

    public static String getPathString(Text to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, Text to) throws JDOMException {
        XPathHelper.checkPathStringArguments(from, to);
        if (to == from) {
            return "node()";
        }
        Element parent = to.getParentElement();
        List<Text> siblings = null;
        StringBuilder path = XPathHelper.getElementPath(from, parent, false);
        if (parent != null) {
            siblings = parent.getContent(Filters.text());
        } else {
            Document doc = to.getDocument();
            if (doc != null) {
                siblings = doc.getContent(Filters.text());
            }
        }
        return XPathHelper.getPositionPath(to, siblings, "text()", path).toString();
    }

    public static String getPathString(Comment to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, Comment to) throws JDOMException {
        XPathHelper.checkPathStringArguments(from, to);
        if (to == from) {
            return "node()";
        }
        Element parent = to.getParentElement();
        List<Comment> siblings = null;
        StringBuilder path = XPathHelper.getElementPath(from, parent, false);
        if (parent != null) {
            siblings = parent.getContent(Filters.comment());
        } else {
            Document doc = to.getDocument();
            if (doc != null) {
                siblings = doc.getContent(Filters.comment());
            }
        }
        return XPathHelper.getPositionPath(to, siblings, "comment()", path).toString();
    }

    public static String getPathString(ProcessingInstruction to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, ProcessingInstruction to) throws JDOMException {
        XPathHelper.checkPathStringArguments(from, to);
        if (to == from) {
            return "node()";
        }
        Element parent = to.getParentElement();
        List<ProcessingInstruction> siblings = null;
        StringBuilder path = XPathHelper.getElementPath(from, parent, false);
        if (parent != null) {
            siblings = parent.getContent(Filters.processinginstruction());
        } else {
            Document doc = to.getDocument();
            if (doc != null) {
                siblings = doc.getContent(Filters.processinginstruction());
            }
        }
        return XPathHelper.getPositionPath(to, siblings, "processing-instruction()", path).toString();
    }

    public static String getPathString(Object to) throws JDOMException {
        return XPathHelper.getPathString(null, to);
    }

    public static String getPathString(Object from, Object to) throws JDOMException {
        if (to instanceof Element) {
            return XPathHelper.getPathString(from, (Element)to);
        }
        if (to instanceof Attribute) {
            return XPathHelper.getPathString(from, (Attribute)to);
        }
        if (to instanceof Text) {
            return XPathHelper.getPathString(from, (Text)to);
        }
        if (to instanceof Comment) {
            return XPathHelper.getPathString(from, (Comment)to);
        }
        if (to instanceof ProcessingInstruction) {
            return XPathHelper.getPathString(from, (ProcessingInstruction)to);
        }
        throw new IllegalArgumentException("\"to \" shall be an Element, Attribute, Text, Comment or ProcessingInstruction node");
    }

    private static void checkPathStringArguments(Object from, Object to) {
        if (from != null && !(from instanceof Element) && !(from instanceof Document)) {
            throw new IllegalArgumentException("from");
        }
        if (to == null) {
            throw new IllegalArgumentException("to");
        }
    }

    private static StringBuilder getElementPath(Object from, Element to, boolean leaf) throws JDOMException {
        if (from instanceof Document) {
            from = null;
        }
        return XPathHelper.getElementPath((Element)from, to, leaf, new StringBuilder());
    }

    private static StringBuilder getElementPath(Element from, Element to, boolean leaf, StringBuilder path) throws JDOMException {
        if (to != from) {
            Namespace ns;
            List<Element> siblings = null;
            Element parent = to.getParentElement();
            if (parent == null) {
                if (parent != from) {
                    throw new JDOMException("The \"from\" node is not an ancestor of the \"to\" node");
                }
                if (to.isRootElement()) {
                    path.append('/');
                }
            } else {
                siblings = parent.getChildren(to.getName(), null);
            }
            if (parent != from) {
                path = XPathHelper.getElementPath(from, parent, false, path);
            }
            if ((ns = to.getNamespace()) == Namespace.NO_NAMESPACE) {
                path = XPathHelper.getPositionPath(to, siblings, to.getName(), path);
            } else {
                String prefix = to.getNamespacePrefix();
                if ("".equals(prefix)) {
                    path.append("*[local-name()='").append(to.getName()).append("']");
                    path = XPathHelper.getPositionPath(to, siblings, null, path);
                } else {
                    path.append(to.getNamespacePrefix()).append(':');
                    path = XPathHelper.getPositionPath(to, siblings, to.getName(), path);
                }
            }
            if (!leaf && path.length() != 0) {
                path.append('/');
            }
        }
        return path;
    }

    private static StringBuilder getPositionPath(Object node, List<?> siblings, String pathToken, StringBuilder buffer) {
        if (buffer == null) {
            buffer = new StringBuilder();
        }
        if (pathToken != null) {
            buffer.append(pathToken);
        }
        if (siblings != null && siblings.size() != 1) {
            int position = 0;
            Iterator<?> i = siblings.iterator();
            while (i.hasNext()) {
                ++position;
                if (i.next() != node) continue;
            }
            buffer.append('[').append(position).append(']');
        }
        return buffer;
    }
}

