/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.input.scanner;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.contrib.input.scanner.ElementListener;
import org.jdom2.contrib.input.scanner.XPathMatcher;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.xml.sax.Attributes;

class JakartaRegExpXPathMatcher
extends XPathMatcher {
    private final Pattern re;
    private final XPathExpression<Object> test;

    public JakartaRegExpXPathMatcher(String expression, ElementListener listener) throws JDOMException {
        super(expression, listener);
        try {
            String pathPattern = JakartaRegExpXPathMatcher.getPathPatternAsRE(expression);
            this.re = Pattern.compile(pathPattern);
            Object testPattern = JakartaRegExpXPathMatcher.getTestPattern(expression);
            if (testPattern != null) {
                testPattern = "." + (String)testPattern;
                this.test = XPathFactory.instance().compile((String)testPattern);
            } else {
                this.test = null;
            }
            if (JakartaRegExpXPathMatcher.isDebug()) {
                System.out.println("Listener " + listener + ":");
                System.out.println("   " + expression + " -> RE    = " + pathPattern);
                System.out.println("   " + expression + " -> XPath = " + (String)testPattern);
            }
        }
        catch (PatternSyntaxException ex1) {
            throw new JDOMException("Illegal XPath expression: " + expression, ex1);
        }
    }

    @Override
    public boolean match(String path, Attributes attrs) {
        return this.re.matcher(path).matches();
    }

    @Override
    public boolean match(String path, Element elt) {
        if (this.test != null) {
            return !this.test.evaluate(elt).isEmpty();
        }
        return true;
    }
}

