/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.perf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jdom2.Verifier;

public class PerfVerifier {
    public static void main(String[] args) throws InterruptedException {
        Thread.currentThread().setPriority(10);
        if (args.length != 1) {
            throw new IllegalArgumentException("We expect a single directory argument.");
        }
        File dir = new File(args[0]);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("We expect a single directory argument.");
        }
        int bestcnt = 50;
        long[] sattnanos = new long[50];
        long[] semtnanos = new long[50];
        long[] schrnanos = new long[50];
        long start = 0L;
        System.out.println("Loading data");
        String[] attnames = PerfVerifier.parseFile(new File(dir, "checkAttributeName.txt"));
        String[] emtnames = PerfVerifier.parseFile(new File(dir, "checkElementName.txt"));
        String[] chardata = PerfVerifier.parseFile(new File(dir, "checkCharacterData.txt"));
        System.out.println("Stabilize");
        Thread.sleep(5000L);
        long prebytes = PerfVerifier.getMemUsed();
        System.out.println("Launch");
        int i = 0;
        int cnt = 200;
        while (--cnt >= 0) {
            long attnanos = 0L;
            long emtnanos = 0L;
            long chrnanos = 0L;
            start = System.nanoTime();
            for (i = attnames.length - 1; i >= 0; --i) {
                Verifier.checkAttributeName(attnames[i]);
            }
            attnanos = System.nanoTime() - start;
            start = System.nanoTime();
            for (i = emtnames.length - 1; i >= 0; --i) {
                Verifier.checkElementName(emtnames[i]);
            }
            emtnanos = System.nanoTime() - start;
            start = System.nanoTime();
            for (i = chardata.length - 1; i >= 0; --i) {
                Verifier.checkCharacterData(chardata[i]);
            }
            chrnanos = System.nanoTime() - start;
            System.out.printf("   Loop   %2d took: att=%.3fms emt=%.3fms char=%.3fms\n", cnt, (double)attnanos / 1000000.0, (double)emtnanos / 1000000.0, (double)chrnanos / 1000000.0);
            PerfVerifier.insertTime(sattnanos, attnanos);
            PerfVerifier.insertTime(semtnanos, emtnanos);
            PerfVerifier.insertTime(schrnanos, chrnanos);
        }
        long memused = PerfVerifier.getMemUsed() - prebytes;
        System.out.printf("    Validating took: att=%.3fms emt=%.3fms char=%.3fms mem=%.3fKB\n", PerfVerifier.avg(sattnanos) / 1000000.0, PerfVerifier.avg(semtnanos) / 1000000.0, PerfVerifier.avg(schrnanos) / 1000000.0, (double)memused / 1024.0);
        Verifier.isAllXMLWhitespace("  ");
        System.out.println("Checks " + (chardata.length + emtnames.length + attnames.length));
    }

    private static final void insertTime(long[] array, long time) {
        int index;
        for (index = array.length - 1; index >= 0 && (array[index] == 0L || time < array[index]); --index) {
        }
        if (++index < array.length) {
            System.arraycopy(array, index, array, index + 1, array.length - index - 1);
            array[index] = time;
        }
    }

    private static final double avg(long[] values) {
        long ret = 0L;
        for (long v : values) {
            ret += v;
        }
        return (double)ret / (double)values.length;
    }

    private static long getMemUsed() {
        long minused = Long.MAX_VALUE;
        int cnt = 0;
        Runtime rt = Runtime.getRuntime();
        try {
            while (cnt < 3) {
                System.gc();
                Thread.yield();
                Thread.sleep(100L);
                long used = rt.totalMemory() - rt.freeMemory();
                if (used < minused) {
                    cnt = 0;
                    minused = used;
                    continue;
                }
                ++cnt;
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Interrupted", ie);
        }
        return minused;
    }

    private static final String[] parseFile(File file) {
        try {
            StringBuilder sb = new StringBuilder(1024);
            ArrayList<String> vals = new ArrayList<String>(10240);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            System.out.println("Loading " + file.getPath());
            int c = 0;
            while ((c = isr.read()) >= 0) {
                if (c == 0) {
                    vals.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append((char)c);
            }
            fis.close();
            String[] ret = new String[vals.size()];
            vals.toArray(ret);
            return ret;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
}

