/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.contrib.schema.ValidationError;
import org.jdom2.output.JDOMLocator;
import org.jdom2.output.SAXOutputter;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Schema {
    public static final Type W3C_XML_SCHEMA = new Type("W3C XML Schema", "http://www.w3.org/2001/XMLSchema");
    public static final Type RELAX_NG = new Type("RELAX NG", "http://relaxng.org/ns/structure/0.9");
    public static final Type RELAX_CORE = new Type("RELAX Core", "http://www.xml.gr.jp/xmlns/relaxCore");
    public static final Type RELAX_NAMESPACE = new Type("RELAX Namespace", "http://www.xml.gr.jp/xmlns/relaxNamespace");
    public static final Type TREX = new Type("TREX", "http://www.thaiopensource.com/trex");
    private final String uri;
    private final Type type;
    private final org.iso_relax.verifier.Schema compiledSchema;

    private Schema(InputSource source, Type type) throws JDOMException, IOException {
        if (source == null || type == null) {
            throw new IllegalArgumentException("source/type/compiledSchema");
        }
        this.uri = source.getSystemId();
        this.type = type;
        try {
            VerifierFactory vf = VerifierFactory.newInstance(type.getLanguage());
            this.compiledSchema = vf.compileSchema(source);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDOMException("Failed to parse schema \"" + this.uri + "\": " + e.getMessage(), e);
        }
    }

    public String getURI() {
        return this.uri;
    }

    public Type getType() {
        return this.type;
    }

    private Verifier newVerifier() throws JDOMException {
        try {
            return this.compiledSchema.newVerifier();
        }
        catch (Exception e) {
            throw new JDOMException("Failed to allocate schema verifier: " + e.getMessage(), e);
        }
    }

    public List<ValidationError> validate(Document doc) throws JDOMException {
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        try {
            Verifier verifier = this.newVerifier();
            verifier.setErrorHandler(errorHandler);
            errorHandler.setContentHandler(verifier.getVerifierHandler());
            new SAXOutputter(errorHandler).output(doc);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return errorHandler.getErrors();
    }

    public List<ValidationError> validate(Element element) throws JDOMException {
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        try {
            Verifier verifier = this.newVerifier();
            verifier.setErrorHandler(errorHandler);
            ArrayList<Element> nodes = new ArrayList<Element>();
            nodes.add(element);
            errorHandler.setContentHandler(verifier.getVerifierHandler());
            new SAXOutputter(errorHandler).output(nodes);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return errorHandler.getErrors();
    }

    public static Schema parse(String uri, Type type) throws JDOMException, IOException {
        return Schema.parse(new InputSource(uri), type);
    }

    public static Schema parse(InputStream byteStream, Type type, String uri) throws JDOMException, IOException {
        InputSource source = new InputSource(byteStream);
        source.setSystemId(uri);
        return Schema.parse(source, type);
    }

    public static Schema parse(Reader reader, Type type, String uri) throws JDOMException, IOException {
        InputSource source = new InputSource(reader);
        source.setSystemId(uri);
        return Schema.parse(source, type);
    }

    public static Schema parse(File file, Type type) throws JDOMException, IOException {
        InputSource source = new InputSource(new FileInputStream(file));
        source.setSystemId(file.getAbsolutePath());
        return Schema.parse(source, type);
    }

    public static Schema parse(InputSource source, Type type) throws JDOMException, IOException {
        return new Schema(source, type);
    }

    public static final class Type {
        private final String name;
        private final String language;

        protected Type(String name, String language) {
            this.name = name;
            this.language = language;
        }

        public String getName() {
            return this.name;
        }

        public String getLanguage() {
            return this.language;
        }

        public int hashCode() {
            return this.language.hashCode();
        }

        public String toString() {
            return this.language;
        }

        public boolean equals(Object o) {
            return o == this || o != null && this.hashCode() == o.hashCode() && this.getClass().getName().equals(o.getClass().getName());
        }
    }

    private static final class ValidationErrorHandler
    extends XMLFilterImpl {
        private List<ValidationError> errors = new LinkedList<ValidationError>();
        private JDOMLocator locator = null;

        public ValidationErrorHandler() {
        }

        public ValidationErrorHandler(XMLReader parent) {
            super(parent);
        }

        public List<ValidationError> getErrors() {
            return this.errors.size() == 0 ? null : this.errors;
        }

        private Object getCurrentNode() {
            return this.locator != null ? this.locator.getNode() : null;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            if (locator instanceof JDOMLocator) {
                this.locator = (JDOMLocator)locator;
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.errors.add(new ValidationError(ValidationError.FATAL, e.getMessage(), this.getCurrentNode()));
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.errors.add(new ValidationError(ValidationError.ERROR, e.getMessage(), this.getCurrentNode()));
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.errors.add(new ValidationError(ValidationError.WARNING, e.getMessage(), this.getCurrentNode()));
        }
    }
}

