/*
 * Copyright (C) 2017 XStream Committers.
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 *
 * Created on 13. February 2017 by Joerg Schaible
 */
package com.thoughtworks.xstream.converters.time;

import java.time.Duration;
import java.time.format.DateTimeParseException;
 
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;


/**
 * Converts a {@link Duration} instance to string.
 *
 * @author J&ouml;rg Schaible
 * @since 1.4.10
 */
public class DurationConverter extends AbstractSingleValueConverter {

    @Override
    public boolean canConvert(@SuppressWarnings("rawtypes") final Class type) {
        return Duration.class == type;
    }

    @Override
    public Duration fromString(final String str) {
        try {
            return Duration.parse(str);
        } catch (final DateTimeParseException ex) {
            final RuntimeException exception = new RuntimeException("Cannot parse value as duration", ex);
//            exception.add("value", str);
            throw exception;
        }
    }
}
