/*
 * Copyright (C) 2017 XStream Committers.
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 *
 * Created on 13. January 2017 by Matej Cimbora
 */
package com.thoughtworks.xstream.converters.time;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
 
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;


/**
 * Converts a {@link java.time.LocalDate} to a string.
 *
 * @author Matej Cimbora
 * @since 1.4.10
 */
public class LocalDateConverter extends AbstractSingleValueConverter {

    @Override
    public boolean canConvert(@SuppressWarnings("rawtypes") final Class type) {
        return LocalDate.class == type;
    }

    @Override
    public Object fromString(final String str) {
        try {
            return LocalDate.parse(str);
        } catch (final DateTimeParseException e) {
            final RuntimeException exception = new RuntimeException("Cannot parse value as local date", e);
//            exception.add("value", str);
            throw exception;
        }
    }

}
