/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.dom4j;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import com.weicoder.dom4j.AttributeDom4J;
import com.weicoder.xml.Attribute;
import com.weicoder.xml.Document;
import com.weicoder.xml.Element;
import java.util.List;
import org.dom4j.DocumentHelper;

public final class ElementDom4J
implements Element {
    private Document doc;
    private org.dom4j.Element element;

    public ElementDom4J(String name) {
        this.element = DocumentHelper.createElement(name);
    }

    public ElementDom4J(org.dom4j.Element e) {
        this.element = e;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Element setDocument(Document doc) {
        this.doc = doc;
        return this;
    }

    @Override
    public Element add(Element e) {
        this.element.add(((ElementDom4J)e).getElement());
        return this;
    }

    @Override
    public Element addElement(String name, String text) {
        this.element.add(DocumentHelper.createElement(name).addText(text));
        return this;
    }

    @Override
    public Element addElement(String name) {
        return this.addElement(name, "");
    }

    @Override
    public Element add(Attribute a) {
        this.element.add(((AttributeDom4J)a).getAttribute());
        return this;
    }

    @Override
    public Element addAttribute(String name, String value) {
        this.element.addAttribute(name, value);
        return this;
    }

    @Override
    public Element setName(String name) {
        this.element.setName(name);
        return this;
    }

    @Override
    public List<Attribute> getAttributes() {
        List<org.dom4j.Attribute> list = this.element.attributes();
        if (U.E.isEmpty(list)) {
            return W.L.empty();
        }
        int size = list.size();
        List attributes = W.L.list((int)size);
        for (int i = 0; i < size; ++i) {
            attributes.add(new AttributeDom4J(list.get(i)));
        }
        return attributes;
    }

    @Override
    public List<Element> getElements(String node) {
        return this.getElementList(this.element.elements(node));
    }

    @Override
    public List<Element> getElements() {
        return this.getElementList(this.element.elements());
    }

    @Override
    public Element getElement(String node) {
        return new ElementDom4J(this.element.element(node));
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public String getText() {
        return this.element.getTextTrim();
    }

    public boolean isEmpty() {
        return U.E.isEmpty((Object)this.element);
    }

    public Element setAttribute(Attribute a) {
        this.element.add(((AttributeDom4J)a).getAttribute());
        return this;
    }

    public Element setAttribute(String name, String value) {
        this.element.addAttribute(name, value);
        return this;
    }

    @Override
    public String getAttributeValue(String name) {
        return this.element.attributeValue(name);
    }

    @Override
    public Element setText(String text) {
        this.element.setText(text);
        return this;
    }

    public org.dom4j.Element getElement() {
        return this.element;
    }

    public void setElement(org.dom4j.Element e) {
        this.element = e;
    }

    @Override
    public Attribute getAttribute(String name) {
        return new AttributeDom4J(this.element.attribute(name));
    }

    public String toString() {
        return this.element.asXML();
    }

    private List<Element> getElementList(List<?> list) {
        if (U.E.isEmpty(list)) {
            return W.L.empty();
        }
        int size = list.size();
        List lsElement = W.L.list((int)size);
        for (int i = 0; i < size; ++i) {
            lsElement.add(new ElementDom4J((org.dom4j.Element)list.get(i)));
        }
        return lsElement;
    }
}

