/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.xml.builder;

import com.weicoder.dom4j.AttributeDom4J;
import com.weicoder.dom4j.DocumentDom4J;
import com.weicoder.dom4j.ElementDom4J;
import com.weicoder.dom4j.input.XMLReadDom4J;
import com.weicoder.dom4j.output.FormatDom4J;
import com.weicoder.dom4j.output.XMLWriteDom4J;
import com.weicoder.xml.Attribute;
import com.weicoder.xml.Document;
import com.weicoder.xml.Element;
import com.weicoder.xml.input.XMLRead;
import com.weicoder.xml.output.Format;
import com.weicoder.xml.output.XMLWrite;
import com.weicoder.xml.params.XmlParams;
import java.io.File;
import java.io.InputStream;

public final class XmlBuilder {
    public static Format createFormat() {
        return XmlBuilder.createFormat(XmlParams.ENCODING);
    }

    public static Format createFormat(String encoding) {
        return new FormatDom4J(encoding);
    }

    public static Document createDocument() {
        return new DocumentDom4J();
    }

    public static Document createDocument(String root) {
        return XmlBuilder.createDocument(XmlBuilder.createElement(root));
    }

    public static Document createDocument(Element e) {
        return new DocumentDom4J(e);
    }

    public static Element createElement() {
        return XmlBuilder.createElement(XmlParams.ROOT);
    }

    public static Element createElement(String name) {
        return new ElementDom4J(name);
    }

    public static Attribute createAttribute(String name, String value) {
        return new AttributeDom4J(name, value);
    }

    public static XMLWrite createXMLOutput() {
        return XmlBuilder.createXMLOutput(XmlBuilder.createFormat());
    }

    public static XMLWrite createXMLOutput(Format format) {
        return new XMLWriteDom4J(format);
    }

    public static XMLRead createXMLRead() {
        return new XMLReadDom4J();
    }

    public static Document readDocument(String xml) {
        return XmlBuilder.createXMLRead().build(xml);
    }

    public static Document readDocument(File file) {
        return XmlBuilder.createXMLRead().build(file);
    }

    public static Document readDocument(InputStream in) {
        return XmlBuilder.createXMLRead().build(in);
    }

    private XmlBuilder() {
    }
}

