/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Predicated;

public class DefaultFilterExpr
extends DefaultExpr
implements FilterExpr,
Predicated {
    private static final long serialVersionUID = -549640659288005735L;
    private Expr expr;
    private PredicateSet predicates;

    public DefaultFilterExpr(PredicateSet predicateSet) {
        this.predicates = predicateSet;
    }

    public DefaultFilterExpr(Expr expr, PredicateSet predicateSet) {
        this.expr = expr;
        this.predicates = predicateSet;
    }

    @Override
    public void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    @Override
    public List<Predicate> getPredicates() {
        return this.predicates.getPredicates();
    }

    @Override
    public PredicateSet getPredicateSet() {
        return this.predicates;
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    public String toString() {
        return "[(DefaultFilterExpr): expr: " + String.valueOf(this.expr) + " predicates: " + String.valueOf(this.predicates) + " ]";
    }

    @Override
    public String getText() {
        Object text = "";
        if (this.expr != null) {
            text = this.expr.getText();
        }
        text = (String)text + this.predicates.getText();
        return text;
    }

    @Override
    public Expr simplify() {
        this.predicates.simplify();
        if (this.expr != null) {
            this.expr = this.expr.simplify();
        }
        if (this.predicates.getPredicates().size() == 0) {
            return this.getExpr();
        }
        return this;
    }

    @Override
    public boolean asBoolean(Context context) throws JaxenException {
        ArrayList results = null;
        if (this.expr != null) {
            results = this.expr.evaluate(context);
        } else {
            List<?> nodeSet = context.getNodeSet();
            ArrayList list = new ArrayList(nodeSet.size());
            list.addAll(nodeSet);
            results = list;
        }
        if (results instanceof Boolean) {
            Boolean b = (Boolean)((Object)results);
            return b;
        }
        if (results instanceof List) {
            return this.getPredicateSet().evaluateAsBoolean(results, context.getContextSupport());
        }
        return false;
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        List<Object> results = this.getExpr().evaluate(context);
        if (results instanceof List) {
            List<Object> newresults;
            results = newresults = this.getPredicateSet().evaluatePredicates(results, context.getContextSupport());
        }
        return results;
    }
}

