/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;

public class DefaultFunctionCallExpr
extends DefaultExpr
implements FunctionCallExpr {
    private static final long serialVersionUID = -4747789292572193708L;
    private String prefix;
    private String functionName;
    private List<Expr> parameters;

    public DefaultFunctionCallExpr(String prefix, String functionName) {
        this.prefix = prefix;
        this.functionName = functionName;
        this.parameters = new ArrayList<Expr>();
    }

    @Override
    public void addParameter(Expr parameter) {
        this.parameters.add(parameter);
    }

    public List<Expr> getParameters() {
        return this.parameters;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getText() {
        StringBuffer buf = new StringBuffer();
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            buf.append(prefix);
            buf.append(":");
        }
        buf.append(this.getFunctionName());
        buf.append("(");
        Iterator<Expr> paramIter = this.getParameters().iterator();
        while (paramIter.hasNext()) {
            Expr eachParam = paramIter.next();
            buf.append(eachParam.getText());
            if (!paramIter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Expr simplify() {
        List<Expr> paramExprs = this.getParameters();
        int paramSize = paramExprs.size();
        ArrayList<Expr> newParams = new ArrayList<Expr>(paramSize);
        for (int i = 0; i < paramSize; ++i) {
            Expr eachParam = paramExprs.get(i);
            newParams.add(eachParam.simplify());
        }
        this.parameters = newParams;
        return this;
    }

    public String toString() {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return "[(DefaultFunctionCallExpr): " + this.getFunctionName() + "(" + String.valueOf(this.getParameters()) + ") ]";
        }
        return "[(DefaultFunctionCallExpr): " + this.getPrefix() + ":" + this.getFunctionName() + "(" + String.valueOf(this.getParameters()) + ") ]";
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        String prefix = this.getPrefix();
        String namespaceURI = null;
        if (prefix != null && !"".equals(prefix)) {
            namespaceURI = context.translateNamespacePrefixToUri(prefix);
        }
        Function func = context.getFunction(namespaceURI, prefix, this.getFunctionName());
        List<Object> paramValues = this.evaluateParams(context);
        return func.call(context, paramValues);
    }

    public List<Object> evaluateParams(Context context) throws JaxenException {
        List<Expr> paramExprs = this.getParameters();
        int paramSize = paramExprs.size();
        ArrayList<Object> paramValues = new ArrayList<Object>(paramSize);
        for (int i = 0; i < paramSize; ++i) {
            Expr eachParam = paramExprs.get(i);
            Object eachValue = eachParam.evaluate(context);
            paramValues.add(eachValue);
        }
        return paramValues;
    }
}

