/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper;

import com.what3words.javawrapper.What3WordsV3Interceptor;
import com.what3words.javawrapper.request.AutosuggestRequest;
import com.what3words.javawrapper.request.AutosuggestSelectionRequest;
import com.what3words.javawrapper.request.AutosuggestWithCoordinatesRequest;
import com.what3words.javawrapper.request.AvailableLanguagesRequest;
import com.what3words.javawrapper.request.BoundingBox;
import com.what3words.javawrapper.request.ConvertTo3WARequest;
import com.what3words.javawrapper.request.ConvertToCoordinatesRequest;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.request.GridSectionGeoJsonRequest;
import com.what3words.javawrapper.request.GridSectionRequest;
import com.what3words.javawrapper.request.SourceApi;
import com.what3words.javawrapper.services.What3WordsV3Service;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class What3WordsV3 {
    private static String DEFAULT_ENDPOINT = "https://api.what3words.com/v3/";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String HEADER_WHAT3WORDS_API_KEY = "X-Api-Key";
    public static final String W3W_WRAPPER = "X-W3W-Wrapper";
    public static final String ANDROID_CERT_HEADER = "X-Android-Cert";
    public static final String ANDROID_PACKAGE_HEADER = "X-Android-Package";
    private Retrofit retrofit;
    private OkHttpClient okHttpClient;

    public What3WordsV3(String apiKey) {
        this(apiKey, DEFAULT_ENDPOINT);
    }

    public What3WordsV3(String apiKey, String endpoint) {
        this(apiKey, endpoint, null, null, null);
    }

    public What3WordsV3(String apiKey, String endpoint, Map<String, String> headers) {
        this(apiKey, endpoint, null, null, headers);
    }

    protected What3WordsV3(String apiKey, String packageName, String signature, Map<String, String> headers) {
        this.setupHttpClient(apiKey, DEFAULT_ENDPOINT, packageName, signature, headers);
    }

    protected What3WordsV3(String apiKey, String endpoint, String packageName, String signature, Map<String, String> headers) {
        this.setupHttpClient(apiKey, endpoint, packageName, signature, headers);
    }

    private void setupHttpClient(String apiKey, String endpoint, String packageName, String signature, Map<String, String> headers) {
        this.okHttpClient = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new What3WordsV3Interceptor(apiKey, packageName, signature, headers)).build();
        this.retrofit = new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.getOkHttpClientInstance()).build();
    }

    public Retrofit getRetrofitInstance() {
        return this.retrofit;
    }

    private OkHttpClient getOkHttpClientInstance() {
        return this.okHttpClient;
    }

    public ConvertTo3WARequest.Builder convertTo3wa(Coordinates coordinates) {
        return new ConvertTo3WARequest.Builder(this, coordinates);
    }

    public ConvertToCoordinatesRequest.Builder convertToCoordinates(String words) {
        return new ConvertToCoordinatesRequest.Builder(this, words);
    }

    public AutosuggestRequest.Builder autosuggest(String input) {
        return new AutosuggestRequest.Builder(this, input);
    }

    public AutosuggestWithCoordinatesRequest.Builder autosuggestWithCoordinates(String input) {
        return new AutosuggestWithCoordinatesRequest.Builder(this, input);
    }

    public AutosuggestSelectionRequest.Builder autosuggestionSelection(String rawInput, String selection, int rank, SourceApi sourceApi) {
        return new AutosuggestSelectionRequest.Builder(this, rawInput, selection, rank, sourceApi);
    }

    public GridSectionRequest.Builder gridSection(BoundingBox boundingBox) {
        return new GridSectionRequest.Builder(this, boundingBox);
    }

    public GridSectionGeoJsonRequest.Builder gridSectionGeoJson(BoundingBox boundingBox) {
        return new GridSectionGeoJsonRequest.Builder(this, boundingBox);
    }

    public AvailableLanguagesRequest.Builder availableLanguages() {
        return new AvailableLanguagesRequest.Builder(this);
    }

    public What3WordsV3Service what3words() {
        return (What3WordsV3Service)this.getRetrofitInstance().create(What3WordsV3Service.class);
    }
}

