/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper.request;

import com.google.gson.stream.MalformedJsonException;
import com.what3words.javawrapper.What3WordsV3;
import com.what3words.javawrapper.request.AbstractBuilder;
import com.what3words.javawrapper.request.AutosuggestInputType;
import com.what3words.javawrapper.request.AutosuggestOptions;
import com.what3words.javawrapper.request.BoundingBox;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.request.SourceApi;
import com.what3words.javawrapper.response.APIError;
import com.what3words.javawrapper.response.APIResponse;
import com.what3words.javawrapper.response.AutosuggestSelection;
import com.what3words.javawrapper.response.ErrorResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import retrofit2.Converter;

public class AutosuggestSelectionRequest {
    protected What3WordsV3 api;
    private String rawInput;
    private String selection;
    private String rank;
    private String sourceApi;
    private String nResults;
    private String focus;
    private String nFocusResults;
    private String clipToCountry;
    private String clipToBoundingBox;
    private String clipToCircle;
    private String clipToPolygon;
    private String inputType;
    private String language;
    private String preferLand;

    private AutosuggestSelectionRequest(Builder builder) {
        this.api = builder.api;
        this.rawInput = builder.rawInput;
        this.selection = builder.selection;
        this.rank = builder.rank;
        this.sourceApi = builder.sourceApi;
        this.nResults = builder.nResults;
        this.focus = builder.focus;
        this.nFocusResults = builder.nFocusResults;
        this.clipToCountry = builder.clipToCountry;
        this.clipToBoundingBox = builder.clipToBoundingBox;
        this.clipToCircle = builder.clipToCircle;
        this.clipToPolygon = builder.clipToPolygon;
        this.inputType = builder.inputType;
        this.language = builder.language;
        this.preferLand = builder.preferLand;
    }

    private AutosuggestSelection execute() {
        if (this.api.getRetrofitInstance().baseUrl().host().contains(".what3words.com") || this.api.getRetrofitInstance().baseUrl().host().contains(".w3w.io")) {
            APIResponse response;
            block8: {
                APIError error;
                try {
                    response = new APIResponse(this.api.what3words().autosuggestSelection(this.rawInput, this.selection, this.rank, this.sourceApi, this.nResults, this.focus, this.nFocusResults, this.clipToCountry, this.clipToBoundingBox, this.clipToCircle, this.clipToPolygon, this.inputType, this.language, this.preferLand).execute());
                    if (response.isSuccessful()) break block8;
                    Converter errorConverter = this.api.getRetrofitInstance().responseBodyConverter(ErrorResponse.class, new Annotation[0]);
                    try {
                        error = ((ErrorResponse)errorConverter.convert((Object)response.getResponse().errorBody())).getError();
                    }
                    catch (MalformedJsonException e) {
                        error = new APIError();
                        error.setCode("UnknownError");
                        error.setMessage(response.getResponse().raw().message());
                    }
                    catch (IOException e) {
                        error = new APIError();
                        error.setCode("NetworkError");
                        error.setMessage(e.getMessage());
                    }
                    response.setAPIError(error);
                }
                catch (IOException e) {
                    response = new APIResponse(null);
                    error = new APIError();
                    error.setCode("NetworkError");
                    error.setMessage(e.getMessage());
                    response.setAPIError(error);
                }
            }
            APIError error = response.getAPIError();
            if (error != null) {
                APIResponse.What3WordsError errorEnum = APIResponse.What3WordsError.get(error.getCode());
                if (errorEnum == null) {
                    errorEnum = APIResponse.What3WordsError.UNKNOWN_ERROR;
                }
                errorEnum.setMessage(error.getMessage());
                response.setError(errorEnum);
            }
            AutosuggestSelection entity = new AutosuggestSelection();
            entity.setResponse(response);
            return entity;
        }
        APIResponse response = new APIResponse(null);
        APIError error = new APIError();
        error.setCode("NetworkError");
        error.setMessage("autosuggest-seletion not available on enterprise api.");
        response.setAPIError(error);
        AutosuggestSelection entity = new AutosuggestSelection();
        entity.setResponse(response);
        return entity;
    }

    public static class Builder
    extends AbstractBuilder<AutosuggestSelection> {
        private String rawInput;
        private String selection;
        private String rank;
        private String sourceApi;
        private String nResults;
        private String focus;
        private String nFocusResults;
        private String clipToCountry;
        private String clipToBoundingBox;
        private String clipToCircle;
        private String clipToPolygon;
        private String inputType;
        private String language;
        private String preferLand;

        public Builder(What3WordsV3 api, String rawInput, String selection, int rank, SourceApi sourceApi) {
            super(api);
            this.rawInput = rawInput;
            this.selection = selection;
            this.rank = String.valueOf(rank);
            this.sourceApi = sourceApi.toString().toLowerCase();
        }

        public Builder nResults(int n) {
            this.nResults = String.valueOf(n);
            return this;
        }

        public Builder focus(Coordinates coordinates) {
            this.focus = String.valueOf(coordinates.lat) + "," + String.valueOf(coordinates.lng);
            return this;
        }

        public Builder nFocusResults(int n) {
            this.nFocusResults = String.valueOf(n);
            return this;
        }

        public Builder clipToCircle(Coordinates centre, double radius) {
            this.clipToCircle = String.valueOf(centre.lat) + "," + String.valueOf(centre.lng) + "," + String.valueOf(radius);
            return this;
        }

        public Builder clipToPolygon(Coordinates ... polygon) {
            ArrayList<String> coordinatesList = new ArrayList<String>();
            for (Coordinates coordinates : polygon) {
                coordinatesList.add(String.valueOf(coordinates.lat));
                coordinatesList.add(String.valueOf(coordinates.lng));
            }
            this.clipToPolygon = Builder.join(",", coordinatesList.toArray(new String[0]));
            return this;
        }

        public Builder clipToBoundingBox(BoundingBox boundingBox) {
            this.clipToBoundingBox = String.valueOf(boundingBox.sw.lat) + "," + String.valueOf(boundingBox.sw.lng) + "," + String.valueOf(boundingBox.ne.lat) + "," + String.valueOf(boundingBox.ne.lng);
            return this;
        }

        public Builder clipToCountry(String ... countryCodes) {
            this.clipToCountry = Builder.join(",", countryCodes);
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder inputType(AutosuggestInputType type) {
            this.inputType = type.toString();
            return this;
        }

        public Builder preferLand(boolean preferLand) {
            this.preferLand = Boolean.toString(preferLand);
            return this;
        }

        public Builder options(AutosuggestOptions options) {
            if (options.getNResults() != null) {
                this.nResults(options.getNResults());
            }
            if (options.getFocus() != null) {
                this.focus(options.getFocus());
            }
            if (options.getNFocusResults() != null) {
                this.nFocusResults(options.getNFocusResults());
            }
            if (options.getClipToCountry() != null) {
                this.clipToCountry(options.getClipToCountry().toArray(new String[0]));
            }
            if (options.getClipToCircle() != null) {
                if (options.getClipToCircleRadius() != null) {
                    this.clipToCircle(options.getClipToCircle(), options.getClipToCircleRadius());
                } else {
                    this.clipToCircle(options.getClipToCircle(), 1.0);
                }
            }
            if (options.getClipToPolygon() != null) {
                this.clipToPolygon(options.getClipToPolygon().toArray(new Coordinates[0]));
            }
            if (options.getClipToBoundingBox() != null) {
                this.clipToBoundingBox(options.getClipToBoundingBox());
            }
            if (options.getLanguage() != null) {
                this.language(options.getLanguage());
            }
            if (options.getInputType() != null) {
                this.inputType(options.getInputType());
            }
            if (options.getPreferLand() != null) {
                this.preferLand(options.getPreferLand());
            }
            return this;
        }

        @Override
        public AutosuggestSelection execute() {
            return new AutosuggestSelectionRequest(this).execute();
        }

        private static String join(String separator, String ... values) {
            if (values == null || values.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int end = 0;
            for (String s : values) {
                if (s == null) continue;
                sb.append(s);
                end = sb.length();
                sb.append(separator);
            }
            return sb.substring(0, end);
        }
    }
}

