/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper;

import com.what3words.javawrapper.What3WordsJavaWrapper;
import com.what3words.javawrapper.What3WordsV3Interceptor;
import com.what3words.javawrapper.request.AutosuggestRequest;
import com.what3words.javawrapper.request.AutosuggestSelectionRequest;
import com.what3words.javawrapper.request.AutosuggestWithCoordinatesRequest;
import com.what3words.javawrapper.request.AvailableLanguagesRequest;
import com.what3words.javawrapper.request.BoundingBox;
import com.what3words.javawrapper.request.ConvertTo3WARequest;
import com.what3words.javawrapper.request.ConvertToCoordinatesRequest;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.request.GridSectionGeoJsonRequest;
import com.what3words.javawrapper.request.GridSectionRequest;
import com.what3words.javawrapper.request.SourceApi;
import com.what3words.javawrapper.response.Autosuggest;
import com.what3words.javawrapper.response.IsValid3waResponse;
import com.what3words.javawrapper.response.Suggestion;
import com.what3words.javawrapper.services.What3WordsV3Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class What3WordsV3
implements What3WordsJavaWrapper {
    private static String DEFAULT_ENDPOINT = "https://api.what3words.com/v3/";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String HEADER_WHAT3WORDS_API_KEY = "X-Api-Key";
    public static final String W3W_WRAPPER = "X-W3W-Wrapper";
    public static final String ANDROID_CERT_HEADER = "X-Android-Cert";
    public static final String ANDROID_PACKAGE_HEADER = "X-Android-Package";
    private Retrofit retrofit;
    private OkHttpClient okHttpClient;

    public static Boolean isPossible3wa(String text) {
        String regex = "^/*(?:(?:\\p{L}\\p{M}*)+[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*)+[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*)+|(?:\\p{L}\\p{M}*)+([ \u00a0](?:\\p{L}\\p{M}*)+){1,3}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*)+([ \u00a0](?:\\p{L}\\p{M}*)+){1,3}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*)+([ \u00a0](?:\\p{L}\\p{M}*)+){1,3})$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(text).find();
    }

    public static Boolean didYouMean3wa(String text) {
        String dymRegex = "^/*(?:\\p{L}\\p{M}*){1,}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964 ,\\\\^_/+'&\\:;|\u3000-]{1,2}(?:\\p{L}\\p{M}*){1,}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964 ,\\\\^_/+'&\\:;|\u3000-]{1,2}(?:\\p{L}\\p{M}*){1,}$";
        Pattern pattern = Pattern.compile(dymRegex);
        return pattern.matcher(text).find();
    }

    public static List<String> findPossible3wa(String text) {
        ArrayList<String> allMatches = new ArrayList<String>();
        String searchRegex = "(?:\\p{L}\\p{M}*){1,}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*){1,}[.\uff61\u3002\uff65\u30fb\ufe12\u17d4\u0589\u104b\u06d4\u1362\u0964](?:\\p{L}\\p{M}*){1,}";
        Matcher pattern = Pattern.compile(searchRegex).matcher(text);
        while (pattern.find()) {
            allMatches.add(pattern.group());
        }
        return allMatches;
    }

    public What3WordsV3(String apiKey) {
        this(apiKey, DEFAULT_ENDPOINT);
    }

    public What3WordsV3(String apiKey, String endpoint) {
        this(apiKey, endpoint, null, null, null);
    }

    public What3WordsV3(String apiKey, String endpoint, Map<String, String> headers) {
        this(apiKey, endpoint, null, null, headers);
    }

    protected What3WordsV3(String apiKey, String packageName, String signature, Map<String, String> headers) {
        this.setupHttpClient(apiKey, DEFAULT_ENDPOINT, packageName, signature, headers);
    }

    protected What3WordsV3(String apiKey, String endpoint, String packageName, String signature, Map<String, String> headers) {
        this.setupHttpClient(apiKey, endpoint, packageName, signature, headers);
    }

    private void setupHttpClient(String apiKey, String endpoint, String packageName, String signature, Map<String, String> headers) {
        this.okHttpClient = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new What3WordsV3Interceptor(apiKey, packageName, signature, headers)).build();
        this.retrofit = new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.getOkHttpClientInstance()).build();
    }

    @Override
    public Retrofit getRetrofitInstance() {
        return this.retrofit;
    }

    private OkHttpClient getOkHttpClientInstance() {
        return this.okHttpClient;
    }

    @Override
    public ConvertTo3WARequest.Builder convertTo3wa(Coordinates coordinates) {
        return new ConvertTo3WARequest.Builder(this, coordinates);
    }

    @Override
    public ConvertToCoordinatesRequest.Builder convertToCoordinates(String words) {
        return new ConvertToCoordinatesRequest.Builder(this, words);
    }

    @Override
    public AutosuggestRequest.Builder autosuggest(String input) {
        return new AutosuggestRequest.Builder(this, input);
    }

    @Override
    public AutosuggestWithCoordinatesRequest.Builder autosuggestWithCoordinates(String input) {
        return new AutosuggestWithCoordinatesRequest.Builder(this, input);
    }

    @Override
    public AutosuggestSelectionRequest.Builder autosuggestionSelection(String rawInput, String selection, int rank, SourceApi sourceApi) {
        return new AutosuggestSelectionRequest.Builder(this, rawInput, selection, rank, sourceApi);
    }

    @Override
    public GridSectionRequest.Builder gridSection(BoundingBox boundingBox) {
        return new GridSectionRequest.Builder(this, boundingBox);
    }

    @Override
    public GridSectionGeoJsonRequest.Builder gridSectionGeoJson(BoundingBox boundingBox) {
        return new GridSectionGeoJsonRequest.Builder(this, boundingBox);
    }

    @Override
    public AvailableLanguagesRequest.Builder availableLanguages() {
        return new AvailableLanguagesRequest.Builder(this);
    }

    @Override
    public What3WordsV3Service what3words() {
        return (What3WordsV3Service)this.getRetrofitInstance().create(What3WordsV3Service.class);
    }

    @Override
    public IsValid3waResponse isValid3wa(String words) {
        if (!What3WordsV3.isPossible3wa(words).booleanValue()) {
            return IsValid3waResponse.success(false);
        }
        Autosuggest autosuggest = this.autosuggest(words).execute();
        if (!autosuggest.isSuccessful()) {
            return IsValid3waResponse.error(autosuggest.getError());
        }
        for (Suggestion suggestion : autosuggest.getSuggestions()) {
            if (!suggestion.getWords().replace("/", "").equalsIgnoreCase(words.replace("/", ""))) continue;
            return IsValid3waResponse.success(true);
        }
        return IsValid3waResponse.success(false);
    }
}

