/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class What3WordsV3Interceptor
implements Interceptor {
    private String apiKey;
    private String userAgent;
    private String packageName;
    private String signature;
    private Map<String, String> headers;

    public What3WordsV3Interceptor(String apiKey, String packageName, String signature, Map<String, String> headers) {
        this.apiKey = apiKey;
        this.userAgent = this.getUserAgent();
        this.packageName = packageName;
        this.signature = signature;
        this.headers = headers;
    }

    private String getUserAgent() {
        return "what3words-Java/" + this.getVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private String getVersion() {
        Properties props = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("/version.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props.getProperty("version", "unknown-version");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        builder.header("Content-Type", "application/json");
        builder.header("X-Api-Key", this.apiKey);
        builder.header("X-W3W-Wrapper", this.userAgent);
        if (this.headers != null) {
            for (String name : this.headers.keySet()) {
                String value = this.headers.get(name);
                builder.header(name, value);
            }
        }
        if (this.packageName != null) {
            builder.header("X-Android-Package", this.packageName);
        }
        if (this.signature != null) {
            builder.header("X-Android-Cert", this.signature);
        }
        return chain.proceed(builder.build());
    }
}

