/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper.examples;

import com.what3words.javawrapper.What3WordsV3;
import com.what3words.javawrapper.request.AutosuggestInputType;
import com.what3words.javawrapper.request.AutosuggestOptions;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.response.APIResponse;
import com.what3words.javawrapper.response.Autosuggest;

public class AutosuggestExample {
    public static void main(String[] args) {
        APIResponse.What3WordsError error;
        What3WordsV3 api = new What3WordsV3("what3words-api-key");
        Autosuggest autosuggest = api.autosuggest("filled.count.soap").nResults(3).execute();
        if (autosuggest.isSuccessful()) {
            System.out.println("Autosuggest: " + autosuggest);
        } else {
            APIResponse.What3WordsError errorEnum = autosuggest.getError();
            if (errorEnum == APIResponse.What3WordsError.BAD_N_RESULTS) {
                System.out.println("BadNResults: " + errorEnum.getMessage());
            } else if (errorEnum == APIResponse.What3WordsError.INTERNAL_SERVER_ERROR) {
                System.out.println("InternalServerError: " + errorEnum.getMessage());
            } else if (errorEnum == APIResponse.What3WordsError.NETWORK_ERROR) {
                System.out.println("NetworkError: " + errorEnum.getMessage());
            } else {
                System.out.println((Object)((Object)errorEnum) + ": " + errorEnum.getMessage());
            }
        }
        AutosuggestOptions options = new AutosuggestOptions();
        options.setFocus(new Coordinates(51.520833, -0.195543));
        autosuggest = api.autosuggest("filled.count.soap").options(options).execute();
        if (autosuggest.isSuccessful()) {
            System.out.println("Autosuggest using AutosuggestOptions: " + autosuggest);
        } else {
            error = autosuggest.getError();
            if (error == APIResponse.What3WordsError.BAD_FOCUS) {
                System.out.println("BadFocus: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.INTERNAL_SERVER_ERROR) {
                System.out.println("InternalServerError: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.NETWORK_ERROR) {
                System.out.println("NetworkError: " + error.getMessage());
            } else {
                System.out.println((Object)((Object)error) + ": " + error.getMessage());
            }
        }
        autosuggest = api.autosuggest("filled.count.soap").clipToPolygon(new Coordinates(52.321911, 1.516113), new Coordinates(52.321911, -2.021484), new Coordinates(50.34546, -2.021484), new Coordinates(52.321911, 1.516113)).execute();
        if (autosuggest.isSuccessful()) {
            System.out.println("Autosuggest: " + autosuggest);
        } else {
            error = autosuggest.getError();
            if (error == APIResponse.What3WordsError.BAD_CLIP_TO_CIRCLE) {
                System.out.println("BadClipToCircle: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_CLIP_TO_BOUNDING_BOX) {
                System.out.println("BadClipToBoundingBox: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_CLIP_TO_COUNTRY) {
                System.out.println("BadClipToCountry: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_CLIP_TO_POLYGON) {
                System.out.println("BadClipToPolygon: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.INTERNAL_SERVER_ERROR) {
                System.out.println("InternalServerError: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.NETWORK_ERROR) {
                System.out.println("NetworkError: " + error.getMessage());
            } else {
                System.out.println((Object)((Object)error) + ": " + error.getMessage());
            }
        }
        autosuggest = api.autosuggest("filled.count.soap").focus(new Coordinates(51.520833, -0.195543)).nFocusResults(1).nResults(3).execute();
        if (autosuggest.isSuccessful()) {
            System.out.println("Autosuggest: " + autosuggest);
        } else {
            error = autosuggest.getError();
            if (error == APIResponse.What3WordsError.BAD_FOCUS) {
                System.out.println("BadFocus: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_N_FOCUS_RESULTS) {
                System.out.println("BadNFocusResults: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.INTERNAL_SERVER_ERROR) {
                System.out.println("InternalServerError: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.NETWORK_ERROR) {
                System.out.println("NetworkError: " + error.getMessage());
            } else {
                System.out.println((Object)((Object)error) + ": " + error.getMessage());
            }
        }
        autosuggest = api.autosuggest("{\"_isInGrammar\":\"yes\",\"_isSpeech\":\"yes\",\"_hypotheses\":[{\"_score\":342516,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6546,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34225,\"_orthography\":\"tend\",\"_conf\":6964,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":43800,\"_orthography\":\"poached\",\"_conf\":6181,\"_endTimeMs\":4060,\"_beginTimeMs\":3220}]},{\"_score\":342631,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6498,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34340,\"_orthography\":\"tent\",\"_conf\":6772,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":43800,\"_orthography\":\"poached\",\"_conf\":6181,\"_endTimeMs\":4060,\"_beginTimeMs\":3220}]},{\"_score\":342668,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6474,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34225,\"_orthography\":\"tend\",\"_conf\":6964,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":41696,\"_orthography\":\"perch\",\"_conf\":5950,\"_endTimeMs\":4020,\"_beginTimeMs\":3220}]},{\"_score\":342670,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6474,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34379,\"_orthography\":\"tinge\",\"_conf\":6705,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":43800,\"_orthography\":\"poached\",\"_conf\":6181,\"_endTimeMs\":4060,\"_beginTimeMs\":3220}]},{\"_score\":342783,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6426,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34340,\"_orthography\":\"tent\",\"_conf\":6772,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":41696,\"_orthography\":\"perch\",\"_conf\":5950,\"_endTimeMs\":4020,\"_beginTimeMs\":3220}]},{\"_score\":342822,\"_startRule\":\"whatthreewordsgrammar#_main_\",\"_conf\":6402,\"_endTimeMs\":6360,\"_beginTimeMs\":1570,\"_lmScore\":300,\"_items\":[{\"_type\":\"terminal\",\"_score\":34379,\"_orthography\":\"tinge\",\"_conf\":6705,\"_endTimeMs\":2250,\"_beginTimeMs\":1580},{\"_type\":\"terminal\",\"_score\":47670,\"_orthography\":\"artichokes\",\"_conf\":7176,\"_endTimeMs\":3180,\"_beginTimeMs\":2260},{\"_type\":\"terminal\",\"_score\":41696,\"_orthography\":\"perch\",\"_conf\":5950,\"_endTimeMs\":4020,\"_beginTimeMs\":3220}]}],\"_resultType\":\"NBest\"}").inputType(AutosuggestInputType.VOCON_HYBRID).language("en").execute();
        if (autosuggest.isSuccessful()) {
            System.out.println("Autosuggest: " + autosuggest);
        } else {
            error = autosuggest.getError();
            if (error == APIResponse.What3WordsError.BAD_INPUT) {
                System.out.println("BadInput: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_INPUT_TYPE) {
                System.out.println("BadInputType: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.BAD_LANGUAGE) {
                System.out.println("BadLanguage: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.INTERNAL_SERVER_ERROR) {
                System.out.println("InternalServerError: " + error.getMessage());
            } else if (error == APIResponse.What3WordsError.NETWORK_ERROR) {
                System.out.println("NetworkError: " + error.getMessage());
            } else {
                System.out.println((Object)((Object)error) + ": " + error.getMessage());
            }
        }
    }
}

