/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper.request;

import com.what3words.javawrapper.What3WordsJavaWrapper;
import com.what3words.javawrapper.request.AbstractBuilder;
import com.what3words.javawrapper.request.AutosuggestInputType;
import com.what3words.javawrapper.request.AutosuggestOptions;
import com.what3words.javawrapper.request.BoundingBox;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.request.Request;
import com.what3words.javawrapper.response.AutosuggestWithCoordinates;
import java.util.ArrayList;
import java.util.Arrays;

public class AutosuggestWithCoordinatesRequest
extends Request<AutosuggestWithCoordinates> {
    private String input;
    private String nResults;
    private String focus;
    private String nFocusResults;
    private String clipToCountry;
    private String clipToBoundingBox;
    private String clipToCircle;
    private String clipToPolygon;
    private String inputType;
    private String language;
    private String locale;
    private String preferLand;

    private AutosuggestWithCoordinatesRequest(Builder builder) {
        super(builder.api);
        this.input = builder.input;
        this.nResults = builder.nResults;
        this.focus = builder.focus;
        this.nFocusResults = builder.nFocusResults;
        this.clipToCountry = builder.clipToCountry;
        this.clipToBoundingBox = builder.clipToBoundingBox;
        this.clipToCircle = builder.clipToCircle;
        this.clipToPolygon = builder.clipToPolygon;
        this.inputType = builder.inputType;
        this.language = builder.language;
        this.locale = builder.locale;
        this.preferLand = builder.preferLand;
    }

    private AutosuggestWithCoordinates execute() {
        return super.execute(this.api.what3words().autosuggestWithCoordinates(this.input, this.nResults, this.focus, this.nFocusResults, this.clipToCountry, this.clipToBoundingBox, this.clipToCircle, this.clipToPolygon, this.inputType, this.language, this.locale, this.preferLand), AutosuggestWithCoordinates.class);
    }

    public static class Builder
    extends AbstractBuilder<AutosuggestWithCoordinates> {
        private String input;
        private String nResults;
        private String focus;
        private String nFocusResults;
        private String clipToCountry;
        private String clipToBoundingBox;
        private String clipToCircle;
        private String clipToPolygon;
        private String inputType;
        private String language;
        private String locale;
        private String preferLand;
        private AutosuggestOptions options;

        public Builder(What3WordsJavaWrapper api, String input) {
            super(api);
            this.input = input;
            this.options = new AutosuggestOptions();
        }

        public Builder nResults(int n) {
            this.nResults = String.valueOf(n);
            this.options.setNResults(n);
            return this;
        }

        public Builder focus(Coordinates coordinates) {
            this.focus = String.valueOf(coordinates.lat) + "," + String.valueOf(coordinates.lng);
            this.options.setFocus(coordinates);
            return this;
        }

        public Builder nFocusResults(int n) {
            this.nFocusResults = String.valueOf(n);
            this.options.setNFocusResults(n);
            return this;
        }

        public Builder clipToCircle(Coordinates centre, double radius) {
            this.clipToCircle = String.valueOf(centre.lat) + "," + String.valueOf(centre.lng) + "," + String.valueOf(radius);
            this.options.setClipToCircle(centre);
            this.options.setClipToCircleRadius(radius);
            return this;
        }

        public Builder clipToPolygon(Coordinates ... polygon) {
            ArrayList<String> coordinatesList = new ArrayList<String>();
            for (Coordinates coordinates : polygon) {
                coordinatesList.add(String.valueOf(coordinates.lat));
                coordinatesList.add(String.valueOf(coordinates.lng));
            }
            this.clipToPolygon = Builder.join(",", coordinatesList.toArray(new String[0]));
            this.options.setClipToPolygon(Arrays.asList(polygon));
            return this;
        }

        public Builder clipToBoundingBox(BoundingBox boundingBox) {
            this.clipToBoundingBox = String.valueOf(boundingBox.sw.lat) + "," + String.valueOf(boundingBox.sw.lng) + "," + String.valueOf(boundingBox.ne.lat) + "," + String.valueOf(boundingBox.ne.lng);
            this.options.setClipToBoundingBox(boundingBox);
            return this;
        }

        public Builder clipToCountry(String ... countryCodes) {
            this.clipToCountry = Builder.join(",", countryCodes);
            this.options.setClipToCountry(Arrays.asList(countryCodes));
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.options.setLanguage(language);
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            this.options.setLocale(locale);
            return this;
        }

        public Builder inputType(AutosuggestInputType type) {
            this.inputType = type.toString();
            this.options.setInputType(type);
            return this;
        }

        public Builder preferLand(boolean preferLand) {
            this.preferLand = Boolean.toString(preferLand);
            this.options.setPreferLand(preferLand);
            return this;
        }

        public Builder options(AutosuggestOptions options) {
            if (options.getNResults() != null) {
                this.nResults(options.getNResults());
            }
            if (options.getFocus() != null) {
                this.focus(options.getFocus());
            }
            if (options.getNFocusResults() != null) {
                this.nFocusResults(options.getNFocusResults());
            }
            if (options.getClipToCountry() != null) {
                this.clipToCountry(options.getClipToCountry().toArray(new String[0]));
            }
            if (options.getClipToCircle() != null) {
                if (options.getClipToCircleRadius() != null) {
                    this.clipToCircle(options.getClipToCircle(), options.getClipToCircleRadius());
                } else {
                    this.clipToCircle(options.getClipToCircle(), 1.0);
                }
            }
            if (options.getClipToPolygon() != null) {
                this.clipToPolygon(options.getClipToPolygon().toArray(new Coordinates[0]));
            }
            if (options.getClipToBoundingBox() != null) {
                this.clipToBoundingBox(options.getClipToBoundingBox());
            }
            if (options.getLanguage() != null) {
                this.language(options.getLanguage());
            }
            if (options.getLocale() != null) {
                this.language(options.getLocale());
            }
            if (options.getInputType() != null) {
                this.inputType(options.getInputType());
            }
            if (options.getPreferLand() != null) {
                this.preferLand(options.getPreferLand());
            }
            return this;
        }

        public AutosuggestOptions getOptions() {
            return this.options;
        }

        @Override
        public AutosuggestWithCoordinates execute() {
            return new AutosuggestWithCoordinatesRequest(this).execute();
        }

        private static String join(String separator, String ... values) {
            if (values == null || values.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int end = 0;
            for (String s : values) {
                if (s == null) continue;
                sb.append(s);
                end = sb.length();
                sb.append(separator);
            }
            return sb.substring(0, end);
        }
    }
}

