/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper.request;

import com.what3words.javawrapper.What3WordsJavaWrapper;
import com.what3words.javawrapper.request.AbstractBuilder;
import com.what3words.javawrapper.request.Coordinates;
import com.what3words.javawrapper.request.Request;
import com.what3words.javawrapper.response.ConvertTo3WA;

public class ConvertTo3WARequest
extends Request<ConvertTo3WA> {
    private String coordinates;
    private String language;
    private String locale;

    private ConvertTo3WARequest(Builder builder) {
        super(builder.api);
        this.coordinates = builder.coordinates;
        this.language = builder.language;
        this.locale = builder.locale;
    }

    private ConvertTo3WA execute() {
        return super.execute(this.api.what3words().convertTo3wa(this.coordinates, this.language, this.locale), ConvertTo3WA.class);
    }

    public static class Builder
    extends AbstractBuilder<ConvertTo3WA> {
        private String coordinates;
        private String language;
        private String locale;

        public Builder(What3WordsJavaWrapper api, Coordinates coordinates) {
            super(api);
            this.coordinates = String.valueOf(coordinates.lat) + "," + String.valueOf(coordinates.lng);
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getLocale() {
            return this.locale;
        }

        @Override
        public ConvertTo3WA execute() {
            return new ConvertTo3WARequest(this).execute();
        }
    }
}

