/*
 * Decompiled with CFR 0.152.
 */
package com.what3words.javawrapper.response;

import com.google.gson.annotations.SerializedName;
import com.what3words.javawrapper.response.APIError;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Response;

public class APIResponse<T> {
    private Response<T> response;
    @SerializedName(value="error")
    private APIError apiError;
    private What3WordsError error;

    public APIResponse(Response<T> response) {
        this.response = response;
    }

    public Response<T> getResponse() {
        return this.response;
    }

    public boolean isSuccessful() {
        return this.response != null && this.response.isSuccessful();
    }

    public T body() {
        return (T)(this.response == null ? null : this.response.body());
    }

    public What3WordsError getError() {
        return this.error;
    }

    public void setError(What3WordsError errorEnum) {
        this.error = errorEnum;
    }

    public APIError getAPIError() {
        return this.apiError;
    }

    public void setAPIError(APIError error) {
        this.apiError = error;
    }

    public static enum What3WordsError {
        BAD_COORDINATES("BadCoordinates"),
        BAD_LANGUAGE("BadLanguage"),
        BAD_WORDS("BadWords"),
        BAD_INPUT("BadInput"),
        BAD_N_RESULTS("BadNResults"),
        BAD_N_FOCUS_RESULTS("BadNFocusResults"),
        BAD_FOCUS("BadFocus"),
        BAD_CLIP_TO_CIRCLE("BadClipToCircle"),
        BAD_CLIP_TO_BOUNDING_BOX("BadClipToBoundingBox"),
        BAD_CLIP_TO_COUNTRY("BadClipToCountry"),
        BAD_CLIP_TO_POLYGON("BadClipToPolygon"),
        BAD_INPUT_TYPE("BadInputType"),
        BAD_BOUNDING_BOX("BadBoundingBox"),
        BAD_BOUNDING_BOX_TOO_BIG("BadBoundingBoxTooBig"),
        INTERNAL_SERVER_ERROR("InternalServerError"),
        INVALID_KEY("InvalidKey"),
        SUSPENDED_KEY("SuspendedKey"),
        UNKNOWN_ERROR("UnknownError"),
        NETWORK_ERROR("NetworkError"),
        INVALID_API_VERSION("InvalidApiVersion"),
        INVALID_REFERRER("InvalidReferrer"),
        INVALID_IP_ADDRESS("InvalidIpAddress"),
        INVALID_APP_CREDENTIALS("InvalidAppCredentials"),
        SDK_ERROR("SdkError"),
        QUOTA_EXCEEDED("QuotaExceeded");

        private final String key;
        private String message;
        private static final Map<String, What3WordsError> lookup;

        private What3WordsError(String key) {
            this.key = key;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getKey() {
            return this.key;
        }

        public static What3WordsError get(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, What3WordsError>();
            for (What3WordsError d : What3WordsError.values()) {
                lookup.put(d.getKey(), d);
            }
        }
    }
}

