/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.compute;

import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import com.woorea.openstack.nova.Nova;
import com.woorea.openstack.nova.model.Image;
import com.woorea.openstack.nova.model.Images;

public class NovaListImages {
    public static void main(String[] args) {
        Keystone keystone = new Keystone("http://identity/v2.0");
        Access access = (Access)keystone.tokens().authenticate((Authentication)new UsernamePassword("", "")).execute();
        keystone.token(access.getToken().getId());
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            access = (Access)keystone.tokens().authenticate((Authentication)new TokenAuthentication(access.getToken().getId())).withTenantId(((Tenant)tenants.getList().get(0)).getId()).execute();
            Nova novaClient = new Nova("http://compute/v2".concat("/").concat(((Tenant)tenants.getList().get(0)).getId()));
            novaClient.token(access.getToken().getId());
            Images images = (Images)novaClient.images().list(true).execute();
            for (Image image : images) {
                System.out.println(image);
            }
        } else {
            System.out.println("No tenants found!");
        }
    }
}

