/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.compute;

import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.nova.Nova;
import com.woorea.openstack.nova.model.Flavor;
import com.woorea.openstack.nova.model.Flavors;
import com.woorea.openstack.nova.model.Image;
import com.woorea.openstack.nova.model.Images;
import com.woorea.openstack.nova.model.KeyPair;
import com.woorea.openstack.nova.model.KeyPairs;
import com.woorea.openstack.nova.model.Server;
import com.woorea.openstack.nova.model.ServerForCreate;

public class NovaCreateServer {
    public static void main(String[] args) {
        Keystone keystone = new Keystone("http://identity/v2.0");
        Access access = (Access)keystone.tokens().authenticate().withUsernamePassword("", "").execute();
        keystone.token(access.getToken().getId());
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            access = (Access)keystone.tokens().authenticate().withToken(access.getToken().getId()).withTenantId(((Tenant)tenants.getList().get(0)).getId()).execute();
            Nova nova = new Nova("http://compute/v2".concat(((Tenant)tenants.getList().get(0)).getId()));
            nova.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
            KeyPairs keysPairs = (KeyPairs)nova.keyPairs().list().execute();
            Images images = (Images)nova.images().list(true).execute();
            Flavors flavors = (Flavors)nova.flavors().list(true).execute();
            ServerForCreate serverForCreate = new ServerForCreate();
            serverForCreate.setName("woorea");
            serverForCreate.setFlavorRef(((Flavor)flavors.getList().get(0)).getId());
            serverForCreate.setImageRef(((Image)images.getList().get(1)).getId());
            serverForCreate.setKeyName(((KeyPair)keysPairs.getList().get(0)).getName());
            serverForCreate.getSecurityGroups().add(new ServerForCreate.SecurityGroup("default"));
            Server server = (Server)nova.servers().boot(serverForCreate).execute();
            System.out.println(server);
        } else {
            System.out.println("No tenants found!");
        }
    }
}

