/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.objectstore;

import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import com.woorea.openstack.keystone.utils.KeystoneUtils;
import com.woorea.openstack.swift.Swift;
import com.woorea.openstack.swift.model.ObjectDownload;
import com.woorea.openstack.swift.model.ObjectForUpload;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SwiftExample {
    private static final File TEST_FILE = new File("pom.xml");

    public static void main(String[] args) throws Exception {
        Keystone keystone = new Keystone("http://identity/v2.0");
        Access access = (Access)keystone.tokens().authenticate((Authentication)new UsernamePassword("", "")).execute();
        keystone.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            access = (Access)keystone.tokens().authenticate((Authentication)new TokenAuthentication(access.getToken().getId())).withTenantId(((Tenant)tenants.getList().get(0)).getId()).execute();
            Swift swift = new Swift(KeystoneUtils.findEndpointURL((List)access.getServiceCatalog(), (String)"object-store", null, (String)"public"));
            swift.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
            swift.containers().create("navidad2").execute();
            System.out.println(swift.containers().list());
            ObjectForUpload upload = new ObjectForUpload();
            upload.setContainer("navidad2");
            upload.setName("example2");
            upload.setInputStream((InputStream)new FileInputStream(TEST_FILE));
            swift.containers().container("navidad2").upload(upload).execute();
            ObjectDownload download = (ObjectDownload)swift.containers().container("navidad").download("example2").execute();
            SwiftExample.write(download.getInputStream(), "example2");
        }
    }

    private static void write(InputStream is, String path) {
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(path));
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)stream).write(buffer, 0, len);
            }
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

