/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.heat;

import com.woorea.openstack.heat.Heat;
import com.woorea.openstack.heat.model.CreateStackParam;
import com.woorea.openstack.heat.model.Stack;
import com.woorea.openstack.heat.model.Stacks;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.utils.KeystoneTokenProvider;
import com.woorea.openstack.keystone.utils.KeystoneUtils;
import java.util.Collections;
import java.util.List;

public class HeatListStacks {
    private static String TEMPLATE = "{\n    \"HeatTemplateFormatVersion\": \"2012-12-12\",\n    \"Parameters\": {},\n    \"Mappings\": {},\n    \"Resources\": {\n        \"my-test-server\": {\n            \"Type\": \"OS::Nova::Server\",\n            \"Properties\": {\n                \"flavor\": \"m1.small\",\n                \"image\": \"centos:latest\"\n            }\n        }\n    }\n}";

    public static void main(String[] args) throws InterruptedException {
        KeystoneTokenProvider keystone = new KeystoneTokenProvider("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v3", "", "");
        Access access = keystone.getAccessByTenant("admin");
        String endpointURL = KeystoneUtils.findEndpointURL((List)access.getServiceCatalog(), (String)"orchestration", null, (String)"public");
        Heat heat = new Heat(endpointURL);
        heat.setTokenProvider(keystone.getProviderByTenant("admin"));
        CreateStackParam param = new CreateStackParam();
        param.setStackName("helloWorld");
        param.setTimeoutMinutes(1);
        param.setParameters(Collections.emptyMap());
        param.setTemplate(TEMPLATE);
        System.out.printf("Create: " + heat.getStacks().create(param).execute(), new Object[0]);
        Thread.sleep(3000L);
        for (Stack s : (Stacks)heat.getStacks().list().execute()) {
            System.out.println(s.getDescription());
            System.out.println(s.getId());
            System.out.println(s.getStackName());
            System.out.println(s.getStackStatus());
            System.out.println(s.getCreationTime());
            System.out.println(s.getUpdatedTime());
            System.out.println(s.getLinks());
            System.out.println(heat.getStacks().byName(s.getStackName()).execute());
        }
    }
}

