/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.network;

import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import com.woorea.openstack.keystone.utils.KeystoneUtils;
import com.woorea.openstack.quantum.Quantum;
import com.woorea.openstack.quantum.model.Network;
import com.woorea.openstack.quantum.model.Networks;
import java.util.List;

public class QuantumListNetworks {
    public static void main(String[] args) {
        Keystone keystone = new Keystone("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v3");
        Access access = (Access)keystone.tokens().authenticate((Authentication)new UsernamePassword("", "")).execute();
        keystone.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            access = (Access)keystone.tokens().authenticate((Authentication)new TokenAuthentication(access.getToken().getId())).withTenantId(((Tenant)tenants.getList().get(0)).getId()).execute();
            Quantum quantum = new Quantum(KeystoneUtils.findEndpointURL((List)access.getServiceCatalog(), (String)"network", null, (String)"public"));
            quantum.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
            Networks networks = (Networks)quantum.networks().list().execute();
            for (Network network : networks) {
                System.out.println(network);
            }
        } else {
            System.out.println("No tenants found!");
        }
    }
}

